#include	"hole_punchd.h"

void	json_srv_accept (void)
{
	socklen_t	len;
	char 	hbuf[NI_MAXHOST], sbuf[NI_MAXSERV];
	int	sock;
	int	yes = 1;
	time_t	atime;

	len = sizeof(json_recv);
	sock = accept(json_sd, (struct sockaddr *)&json_recv, &len);
	if (sock < 0)
	{
		time(&atime);
		fprintf (log_file, "%24.24s %s\n", ctime(&atime), strerror(errno));
		fflush (log_file);
		FD_CLR (json_sd, &fd_save);
		close (json_sd);
		json_sd = 0;
		json_port= 0;
	}
	else
	{
		getnameinfo((struct sockaddr *) &json_recv, len, hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), NI_NUMERICHOST | NI_NUMERICSERV);

		setsockopt (sock, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(yes));
		FD_SET (sock, &fd_save);
		json_fd[sock/8] |= 0x01 << (sock % 8);
		if (debug_sw)
		{
			time(&cur_time);
			fprintf (log_file, "%24.24s json socket connected from %s:%s\n", ctime(&cur_time), hbuf, sbuf);
			fflush (log_file);
		}
	}
}

void	json_srv_recv (int sock)
{
	int	length;
	char	temp[8192];
	char	status[4];
	struct	RepeaterTable	*next;

	if ((length = recv (sock, temp, sizeof(temp), 0)) <= 0)
	{
		FD_CLR (sock, &fd_save);
		//FD_CLR (sock, &json_fd);
		//printf ("debug %2.2x\n", !(0x01 << (sock % 8)));
		json_fd[sock/8] &= !(0x01 << (sock % 8));
		close (sock);
		return;
	}

	send (sock, "{\"Connected Table\":[\n", 21, 0);
	next = RepeaterTablePnt;
	while (next)
	{
		memset (status, 0x00, 4);
		if (next->status == ON) memcpy (status, "on", 2);
		else memcpy (status, "off", 3);
		if (next->f_chain == NULL)
			sprintf (temp, "{\"callsign\":\"%8.8s\",\"ip_address\":\"%s\",\"port\":%d,\"status\":\"%s\",\"area\":\"%c\",\"ur_call\":\"%8.8s\",\"my_call\":\"%8.8s\",\"rpt1_call\":\"%8.8s\",\"rpt2_call\":\"%8.8s\",\"zr_call\":\"%8.8s\"}\r\n\0", next->ar_callsign, 
				inet_ntoa(next->repeater_addr.sin_addr),
				ntohs (next->repeater_addr.sin_port), status, next->area_code[1], 
				next->ur_call, next->my_call, next->rpt1_call, next->rpt2_call,
				next->zr_callsign);
					
		else
			sprintf (temp, "{\"callsign\":\"%8.8s\",\"ip_address\":\"%s\",\"port\":%d,\"status\":\"%s\", \"area\":\"%c\",\"ur_call\":\"%8.8s\",\"my_call\":\"%8.8s\",\"rpt1_call\":\"%8.8s\",\"rpt2_call\":\"%8.8s\",\"zr_call\":\"%8.8s\"},\r\n\0", next->ar_callsign,
				inet_ntoa(next->repeater_addr.sin_addr),
				ntohs(next->repeater_addr.sin_port), status, next->area_code[1], 
				next->ur_call, next->my_call, next->rpt1_call, next->rpt2_call,
				next->zr_callsign);
		
		send (sock, temp, strlen(temp), 0);
		next = next->f_chain;
	}
	send (sock, "]\n}\n", 4, 0);
	json_fd[sock/8] &= !(0x01 << (sock % 8));
	FD_CLR	(sock, &fd_save);
	close (sock);

}

