package iax.client.protocol.call.command.send;

import iax.client.protocol.call.Call;
import iax.client.protocol.frame.FullFrame;
import iax.client.protocol.frame.ProtocolControlFrame;

/**
 * Sends an unsupport
 */
public class Unsupport {

    public static void execute(Call call, FullFrame fullFrame) {
        try {
            ProtocolControlFrame unsupportFrame = new ProtocolControlFrame(call.getSrcCallNo(), false, call.getDestCallNo(), 
                call.getTimestamp(), call.getOseqno(), call.getIseqno(), false, ProtocolControlFrame.UNSUPPORT_SC);
            unsupportFrame.setUnknown(fullFrame.getSubclass());
            call.handleSendFrame(unsupportFrame);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}