package iax.client.protocol.user.command;

import iax.client.protocol.call.Call;
import iax.client.protocol.frame.ProtocolControlFrame;
import iax.client.protocol.peer.Peer;

/**
 * Implements the user command that hangs a given initiated call.
 */
public class HangupCall {
  
    public static void execute(Peer peer) {
        try {
            Call call = peer.getCall();

            ProtocolControlFrame hangupFrame = 
                new ProtocolControlFrame(call.getSrcCallNo(), false, call.getDestCallNo(), call.getTimestamp(), call.getOseqno(),
                        call.getIseqno(), false, ProtocolControlFrame.HANGUP_SC);

            call.handleSendFrame(hangupFrame);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}