(ns src.utils)

; http://www.xilinx.com/support/documentation/application_notes/xapp052.pdf
; LFSR a^32+a^22+a^2+a^1+1
(defn lfsr32-1 [x]
  (bit-and 0xFFFFFFFF
           (bit-xor (bit-shift-left x 1)
                    (if (bit-test x 31)
                      0x00400007
                      0x00000000
                      ))))

(defn lfsr32 [init]
  (lazy-seq (cons init
                  (lfsr32 (lfsr32-1 init))
                  )))

; http://www.xilinx.com/support/documentation/application_notes/xapp052.pdf
; LFSR a^16+a^15+a^13+a^4+1
(defn lfsr16-1 [x]
  (bit-and 0xFFFF
           (bit-xor (bit-shift-left x 1)
                    (if (bit-test x 15)
                      0xA011
                      0x0000
                      ))))

(defn lfsr16 [init]
  (lazy-seq (cons init
                  (lfsr16 (lfsr16-1 init))
                  )))
