//
//  CRTableViewController.m
//  ImageSpliter
//
//  Created by hiroshi tomioka on 13/02/12.
//  Copyright (c) 2013年 hiroshi tomioka. All rights reserved.
//

#import "CRTableViewController.h"
#import <Cocoa/Cocoa.h>
#import "CRDropView.h"

@implementation CRTableViewController {
	NSMutableArray *_dataArray;
	IBOutlet CRDropView *mainView;
	IBOutlet NSTableView *_tableView;
	IBOutlet NSTextField *_textField;
	IBOutlet NSProgressIndicator *_indicator;
}
@synthesize _dirPath;
//@synthesize mainView;

- (id)init
{
    self = [super init];
    if (self) {
        NSLog(@"%s", __func__);

		[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(respondFileDropedNotification:) name:@"files droped" object:nil];
		
        _dataArray = [[NSMutableArray alloc] init];
    }
    return self;
}

- (void)awakeFromNib {

}


#pragma mark - NSTableView data source

- (NSInteger)numberOfRowsInTableView:(NSTableView*)tableView
{
    NSLog(@"%s", __func__);
    
    return _dataArray.count;
}

- (id)tableView:(NSTableView *)tableView objectValueForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row
{
    NSDictionary *data = [_dataArray objectAtIndex:row];
    if ([[tableColumn identifier] isEqualToString:@"TITLE"]) {
        return [data objectForKey:@"title"];
    } else {
        return [data objectForKey:@"description"];
    }
}

//ドロップファイルの通知
- (void)respondFileDropedNotification:(NSNotification*)notification {
	NSDictionary* dic = notification.userInfo;
	NSArray *files = [dic objectForKey:@"files"];
	
	_dataArray = [[NSMutableArray alloc] init];
	for (int i = 0; i < [files count]; i++) {
		NSDictionary *data = @{@"title": [files[i] lastPathComponent],
						 @"description": files[i]};
		[_dataArray addObject:data];
	}
	[_tableView reloadData];
}

NSImage* trimImageByRect(NSImage *image, NSRect trimRect) {
	NSBitmapImageRep* imageRep = [NSBitmapImageRep imageRepWithData:[image TIFFRepresentation] ];
	NSSize pointSize = NSMakeSize(imageRep.pixelsWide, imageRep.pixelsHigh);

	[image setSize:pointSize];

	NSRect newRect = NSZeroRect;
	newRect.size = trimRect.size;
	NSImage *newImage = [ [NSImage alloc] initWithSize:newRect.size];

	[newImage lockFocus];
	[NSGraphicsContext saveGraphicsState];

	[[NSGraphicsContext currentContext] setImageInterpolation:NSImageInterpolationHigh];

	[image drawAtPoint:NSZeroPoint fromRect:trimRect operation:NSCompositeSourceOver fraction:1.0];
	[NSGraphicsContext restoreGraphicsState];
	[newImage unlockFocus];
	
	return newImage;
}

- (IBAction)buildButton:(id)sender {
	NSLog(@"pushed");
	BOOL isDirectory;
	[_indicator setDoubleValue:0];
	if ([[NSFileManager defaultManager] fileExistsAtPath:self._dirPath isDirectory:&isDirectory]) {
		if (isDirectory) {
			_indicator.minValue = 0;
			_indicator.maxValue = [mainView._files count] * 2;
			
			int count = 0;
			int progress = 0;
			for (int i = 0; i < [mainView._files count]; i++) {
				
				NSImage *image;
				NSData *data;
				NSBitmapImageRep *bitmapImageRep;
				
				image = [[NSImage alloc] initWithContentsOfFile:mainView._files[i]];
				data = [image TIFFRepresentation];
				bitmapImageRep = [NSBitmapImageRep imageRepWithData:data];
				NSSize pointSize = NSMakeSize(bitmapImageRep.pixelsWide, bitmapImageRep.pixelsHigh);
				
				if (pointSize.width < pointSize.height) {
					NSString *filename;
					NSData *newData;
					NSDictionary *properties;
					float quality;
					
					filename = [self._dirPath stringByAppendingFormat:@"/%06d.jpg", count++];
					quality = 0.86;
					
					properties = [NSDictionary
								  dictionaryWithObject:[NSNumber numberWithFloat:quality]
								  forKey:NSImageCompressionFactor];
					newData = [bitmapImageRep representationUsingType:NSJPEGFileType
														   properties:properties];
					[newData writeToFile:filename atomically:YES];
					
					progress += 2;
					[_indicator setDoubleValue:progress];
				} else {
					for (int j = 0; j < 2; j++) {
						NSString *filename;
						NSImage *newImage;
						NSData *newData;
						NSDictionary *properties;
						float quality;
						
						NSRect rc = NSMakeRect((pointSize.width / 2.0 * (1 - j)), 0, pointSize.width / 2.0, pointSize.height);
						newImage = trimImageByRect(image, rc);
						
						filename = [self._dirPath stringByAppendingFormat:@"/%06d.jpg", count++];
						quality = 0.86;
						
						newData = [newImage TIFFRepresentation];
						bitmapImageRep = [NSBitmapImageRep imageRepWithData:newData];
						properties = [NSDictionary
									  dictionaryWithObject:[NSNumber numberWithFloat:quality]
									  forKey:NSImageCompressionFactor];
						newData = [bitmapImageRep representationUsingType:NSJPEGFileType
															   properties:properties];
						[newData writeToFile:filename atomically:YES];
						
						[newImage release];
						
						progress++;
						[_indicator setDoubleValue:progress];
					}
				}
				[image release];

			}
			NSRunAlertPanel(@"info", @"finish",
							nil, nil, nil);
		}
	} else {
		NSRunAlertPanel(@"info", @"set a folder",
						nil, nil, nil);
	}
}

- (IBAction)onSelectSaveAs:(id)sender
{
    NSInteger result;
    NSOpenPanel* openPanel;
	
    openPanel = [NSOpenPanel openPanel];
    [openPanel setCanChooseDirectories:YES];
	[openPanel setCanCreateDirectories:YES];
    result = [openPanel runModal];
    if(result == NSOKButton) {
		NSString*	dirPath = [[openPanel URL] path];
		BOOL isDirectory;
		if ([[NSFileManager defaultManager] fileExistsAtPath:dirPath isDirectory:&isDirectory]) {
			if (isDirectory) {
				self._dirPath = dirPath;
				[_textField setStringValue:dirPath];
			} else {
				NSRunAlertPanel(@"info", @"set a folder",
								nil, nil, nil);
			}
		}
	}
}

- (IBAction)onClearButton:(id)sender
{
	[mainView._files removeAllObjects];
	_dataArray = [[NSMutableArray alloc] init];
	[_tableView reloadData];
}

@end
