package com.namaspider.iota.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * @author akado
 *
 */
public class HashUtil {

    public static String sha256(String str) {
        return sha(str, "SHA-256");
    }

    public static String sha256(InputStream in) throws IOException {
        return sha(in, "SHA-256");
    }

    public static String sha512(String str) {
        return sha(str, "SHA-512");
    }

    public static String sha512(InputStream in) throws IOException {
        return sha(in, "SHA-512");
    }

    private static String sha(String str, String function) {
        try {
            return sha(new ByteArrayInputStream(str.getBytes()), function);
        } catch (IOException e) {
            // 発生しない
            throw new RuntimeException(e);
        }
    }

    private static String sha(InputStream in, String function) throws IOException {
        MessageDigest md = getMessageDigest(function);
        DigestInputStream dis = new DigestInputStream(in, md);
        byte[] buffer = new byte[1024];
        int len = 0;
        while (true) {
            len = dis.read(buffer);
            if (len < 0) {
                break;
            }
        }
        return toHexString(md.digest());
    }

    private static MessageDigest getMessageDigest(String function) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(function);
        } catch (NoSuchAlgorithmException e) {
            // functionが不明の場合
            // 発生しない
            throw new RuntimeException(e);
        }
        return md;
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(toHexString(b));
        }
        return sb.toString();
    }

    private static String toHexString(byte b) {
        String hex = Integer.toHexString(b + 128);
        return (hex.length() < 2) ? "0".concat(hex) : hex;
    }
}
