package com.namaspider.iota.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/**
 *
 *
 * @author Akado Takatoshi
 * @see java.util.Properties
 */
public class PropertiesMap extends AbstractMap<String, List<String>> {

	private Map<String, List<String>> propertiesMap;

    public PropertiesMap(Properties properties) {
    	propertiesMap = new HashMap<String, List<String>>();
    	for (Object key : properties.keySet()) {
    		String values = properties.getProperty((String)key);
    		String[] valueArray = values.split(",\\s*");
    		propertiesMap.put((String)key, Arrays.asList(valueArray));
    	}
    }

	/* (非 Javadoc)
	 * @see java.util.AbstractMap#entrySet()
	 */
	@Override
	public Set<Map.Entry<String, List<String>>> entrySet() {
		return propertiesMap.entrySet();
	}
}
