#ifndef _RINGBUFFER_H
#define _RINGBUFFER_H 1
#include <stdio.h>
#include <pthread.h>
#define BUFFER_SIZE 100000


typedef struct {
    unsigned char ts[188];
} cell_t;

typedef struct {
    cell_t *data;
    int top, bottom, end;
    FILE *fp;
    pthread_rwlock_t rwlock;
    unsigned int pcr, pmt;
} buffer_t;

int initBuffer(buffer_t *this, FILE *target); // return pcr's pid
void *fillBuffer(void *buf);
int readBuffer(unsigned char *data, int n_packets,
                unsigned int dropped, void *callback_data);
void freeBuffer(buffer_t *this);
#endif
