/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2009 Akira Ujio
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.8 2003/12/24 07:24:40 honda Exp $
 */

/*
 *	ץå¸⥸塼iphoneѡ
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include <sys/types.h> 
#include <unistd.h>

/*
*	ToppersThread ID¸
*	Thread IDФSignal
*/
pthread_t thread_id;

/*
*	CPU Lock֤ǤΥʥޥ¸
*	sense_lock()ǻѤ
*/
IMS locked_ims=0;

/*
*	¿ųбΤ˳ߥͥȥ٥¸
*	¿ųߤ줿߽Ǥdispatchα
*/
static int nest_level = 0;

/*
*	߽ΤȤTRUEˤʤ
*	sense_context() ContextߤȽǤΤ˻Ѥ
*/
BOOL interrupt_flg = FALSE;


/*
*   ǥѥå
*/
void
dispatch()
{
	if (	enadsp && (!runtsk || (runtsk != schedtsk
						&& setjmp(runtsk->tskctxb.env) == 0))) 
	{
		while (!(runtsk = schedtsk)) 
		{
				sigset_t waitmask;
				sigemptyset(&waitmask);
				sigsuspend(&waitmask);
			}
			longjmp(runtsk->tskctxb.env, 1);
	}
	else
		calltex();
}


/*
 *  ߤΥƥȤΤƤƥǥѥå
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
static void initial_create_tasks(TCB *);
void
exit_and_dispatch() 
{                   
	static BOOL bFirst = TRUE;
	
	if( bFirst )
	{
		/*
		*	ΤߥΥå䥳ƥȤ
		*/
		bFirst = FALSE;
		t_unlock_cpu();
		initial_create_tasks( &tcb_table[0] );
	}
    runtsk = 0;
	dispatch();
}



/*
 *  ץå¸ν
 */


extern void kernel_start();

void
cpu_initialize()
{
	int i;
	TCB *tcb;
	
	/*
	*	TCBΥå򣰤˽ 
	*/
	for(i=0;i<TNUM_TSK;++i)
	{
		tcb = &tcb_table[i];
		tcb->tskctxb.stksize = 0;
	}
	
	/*
	*	CPU Lock֤ˤơΤȤΥʥޥ¸
	*/
	t_lock_cpu();
	sigprocmask(SIG_SETMASK,0,&locked_ims); 
	
	/*
	*	ToppersThread ID¸
	*/
	thread_id = pthread_self();

}

/*
 *  ץå¸νλ
 */
void
cpu_terminate()
{
}

/*
 * ư롼
 *
 */



/*
*	ޡ륹å
* iphone SIGALRMthread IDꤷʤ¤ꡢCocoa(Main Thread)˿Ƥޤ
* äƶκSIGALRMѤThreadToppersJSP ThreadФ
* ΤSIGALRMȯԤ
*/
void
timer_polling(void)
{
	for(;;)
	{
		usleep(10000);
		pthread_kill( thread_id, SIGALRM);
	}
}

/*
*	Cocoa(Main Thread)ToppersJSPФƳߤ򵯤
*/
void
itron_interrupt(int intno)
{
	pthread_kill( thread_id, intno);	
}

/*
*	Toppers JSP for iPhoneư
*	Program Entry(main.mmain()ؿ) δؿǸƤ֤
*	ToppersѤThread졢Cocoa(Main Thread)ڤΥ
*/
void
jsp_for_iphone_start(void)
{	
	pthread_t t;
	
	pthread_attr_t attr;
	pthread_attr_init(&attr);
	
//	struct sched_param priority;
//	priority.sched_priority = 50;
//	pthread_attr_setschedparam(&attr, &priority);
	pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	pthread_create(&t, &attr, (void *)kernel_start, NULL);
	pthread_attr_destroy(&attr);
	//pthread_join(t, NULL);
}

/*
*	ưƥΥåݤ
*	cfg.exeǼư륹åϤ٤̵뤵졢Threadåݤ
*	MINSIGSTKSZ(32kB)ϳݤ롣iPhone OSThread512kBʤΤǡ
*	Ķ륹åɬפʾThread˥åꤹɬפ
*/
static void
initial_create_tasks(TCB *tcb)
{
	static int nTaskReady=1;
	
	/*
	*	åJSP ThreadStack鶯Ū˼
	*	setjmpǥåξ֤
	*/
	volatile int tsk_stack[MINSIGSTKSZ/sizeof(int)];
	tsk_stack[0] = 0;
	tcb->tskctxb.stksize += MINSIGSTKSZ;
	
	if( tcb->tskctxb.stksize < tcb->tinib->stksz )
	{
		/*
		*	ޤå­ʤȤϤ⤦
		*/
		initial_create_tasks( tcb );
	}
	
	if( setjmp( tcb->tskctxb.env) == 0 )
	{
		/*
		*	Ⱦ֤ΥƥȤ¸
		*	ưstart_envΥƥȤѤ뤳Ȥˤʤ
		*/
		memcpy( &tcb->tskctxb.start_env, &tcb->tskctxb.env, sizeof(jmp_buf) );
		
		/*
		*	٤ƤΥФƥåݤ
		*/
		if( nTaskReady < TNUM_TSK )
		{
			++nTaskReady;
			initial_create_tasks( &tcb_table[INDEX_TSK(nTaskReady)] );
		}
		
		/*
		*	νϤ٤ƥΥåȤ꽪Ȥˤ
		*/
		
		/*
		*	Ϥᤫ鵯ư륿ʤϤԤ
		*/
		while (!(runtsk = schedtsk)) {
			sigset_t waitmask;
			sigemptyset(&waitmask);
			sigsuspend(&waitmask);
		}
		
		/*
		*	ֺǽΥ˥פ
		*/
		longjmp( runtsk->tskctxb.env, 1);
	}
	else
	{
		/*
		*	ȡåĥ
		*/
		(*runtsk->tinib->task)(runtsk->tinib->exinf);
		
		ext_tsk();
	}
}

/*
*	ߤ
*	CPU Lock򤷤塢ߥե饰TRUEˤͥȥ٥򣱾夲
*/
void prologue_isr(void)
{
	i_lock_cpu();
	interrupt_flg = TRUE;
	++nest_level;
	i_unlock_cpu();
}

/*
*	߽и
*	CPU Lock򤷤塢ͥȥ٥򣱲
*	⤷ͥȥ٥뤬ˤʤä¾γ߽ʤ֡׵˱dispatch򤹤
*/
void epilogue_isr(void)
{
	i_lock_cpu();
	--nest_level;
	if( nest_level == 0 )
	{
		interrupt_flg = FALSE;
		if(_kernel_reqflg)
		{
			_kernel_reqflg=FALSE;
			dispatch();
		}
	}
	i_unlock_cpu();
}




