/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2009 Akira Ujio
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.9 2003/12/24 07:24:40 honda Exp $
 */

/*
 *	ץå¸⥸塼iPhoneѡ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *	API
 */
#include "api.h"

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

#ifndef _MACRO_ONLY

/*
 *  iPhoneɸ।󥯥롼ɥե
 */

#include <signal.h>
#include <setjmp.h>


/*
 *  TCB Ϣ
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */

/*
 *  TCB ΥեɤΥӥå
 */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */

/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	SIZE	stksize;				/*å*/
	jmp_buf start_env;	/* CPUȻΥƥ*/
	jmp_buf env;				/* CPUƥ */
} CTXB;

/*
 *	ߥϥɥ
 */
#define INHNO_SIGUSR1	SIGUSR1
#define INHNO_SIGUSR2	SIGUSR2

/*
 *   CPU㳰ϥɥ
 */

#define EXCHNO_ZDIV  SIGFPE

/*
 *  ƥֻ
 */

extern BOOL interrupt_flg;

Inline BOOL
sense_context()
{
	return interrupt_flg;
}

extern IMS locked_ims;

Inline BOOL
sense_lock()
{
	IMS currentSet;
	
	sigprocmask(SIG_SETMASK,0,&currentSet);
	
	return currentSet == locked_ims;  
}


#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβʥƥѡ
 *
 */

Inline void
t_lock_cpu()
{
    sigset_t  newmask; 
    sigfillset(&newmask);
    sigprocmask(SIG_SETMASK,&newmask,0);
}

Inline void
t_unlock_cpu()
{
    sigset_t  mask;    
    sigemptyset(&mask);
    sigprocmask(SIG_SETMASK,&mask,0);
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */

#define i_lock_cpu		t_lock_cpu
#define i_unlock_cpu	t_unlock_cpu

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥå
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch();


/*
 *  ߤΥƥȤΤƤƥǥѥå
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */

extern void    exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */


/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */

Inline void
define_inh(INHNO inhno, FP inthdr)
{
		struct sigaction action;

		action.sa_handler = inthdr;
		action.sa_flags   = SA_RESTART;
		sigemptyset(&action.sa_mask);
    
		sigaction(inhno, &action, 0);    
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
    struct sigaction action;

    action.sa_handler = exchdr;
    sigemptyset(&action.sa_mask);

    sigaction(excno, &action, 0);
}

/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 */

/*
 *  ߥϥɥνޥ
 *
 */

extern void prologue_isr(void);
extern void epilogue_isr(void);
#define		INTHDR_ENTRY(inthdr)	void inthdr##_entry(void){ prologue_isr(); inthdr(); epilogue_isr(); }



/*
 *  CPU㳰ϥɥνޥ
 *
 */
#define INT_ENTRY(inthdr)   inthdr##_entry

#define		EXCHDR_ENTRY(exchdr)	void exchdr##_entry(VP sp){ prologue_isr(); exchdr(sp); epilogue_isr(); }

#define EXC_ENTRY(exchdr) exchdr##_entry

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥǥѥå
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x1000) == 0);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x0700) == 0x0700);
}


/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

/*
 *	ߤȯ
 */
extern void itron_interrupt(int intno);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */







