//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "PUMultiRequest.h"
#import "PURequest.h"
#import "PUMacros.h"

@interface PUMultiRequest (Private)

-(void) execNextRequest;

@end

@implementation PUMultiRequest

-(id) init
{
	if (self = [super init]) {
		m_reqs = [[NSMutableArray alloc] init];
		m_errOccurred = NO;
	}
	return self;
}

-(void) dealloc
{
	[m_reqs release];
	[super dealloc];
}

-(void) start:(NSArray*)reqs
{
	[m_reqs removeAllObjects];
	[m_reqs addObjectsFromArray:reqs];
	m_total = [reqs count];
	
	[self execNextRequest];
}

-(void) cancel
{
	[m_reqs removeAllObjects];
	[m_curReq cancel];
}


-(id) delegate 
{
	return m_delegate; 
}

-(void) setDelegate:(id)aDelegate
{ 
	m_delegate = aDelegate; 
}

#pragma mark ___ PURequest delegate ___

-(void) request:(PURequest*)request didCompletedWithResult:(int)code
{
	NSError* err = nil;
	[request responseData:&err];
	// エラーの表示は上位で行う
	if (err) {
		m_errOccurred = YES;
	}
	
	if (m_delegate && [m_delegate respondsToSelector:@selector(multiRequest:didCompletedOne:withProgress:)]) {
		[m_delegate multiRequest:self didCompletedOne:request withProgress:((m_total - [m_reqs count]) / (double)m_total)];
	}
	if (code == kPURequest_Canceled) {
		if (m_delegate && [m_delegate respondsToSelector:@selector(multiRequestDidCompleted:result:)]) {
			[m_delegate multiRequestDidCompleted:self result:kPUMultiRequest_Cancel];
		}		
		[request release];
		return;
	}
	[self execNextRequest];
	[request release];
}

@end

@implementation PUMultiRequest (Private)

-(void) execNextRequest
{
	if ([m_reqs count] > 0) {
		m_curReq = [m_reqs objectAtIndex:0];
		if (m_delegate && [m_delegate respondsToSelector:@selector(multiRequest:willStartOne:)]) {
			if ([m_delegate multiRequest:self willStartOne:m_curReq]) {
				[m_curReq setDelegate:self];
				[m_curReq start];
			}
		}
		[m_curReq retain];
		[m_reqs removeObjectAtIndex:0];
	} else {
		if (m_delegate && [m_delegate respondsToSelector:@selector(multiRequestDidCompleted:result:)]) {
			[m_delegate multiRequestDidCompleted:self result:(m_errOccurred) ? kPUMultiRequest_Fail : kPUMultiRequest_Success];
		}		
	}
}

@end
