//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import <Cocoa/Cocoa.h>

#define STR_TO_DATA(str)	[(NSString*)(str) dataUsingEncoding:NSUTF8StringEncoding]
#define KEY_URL				@"url"
#define KEY_TYPE			@"type"

extern NSString* PURequestErrorDomain;

enum
{
	kPURequest_Incomplete		= -1,	//!< 未完
	kPURequest_NotReplied		= -2,	//!< 応答無し
	kPURequest_ReplyInProgress	= -3,	//!< 進捗中
	kPURequest_Invalid			= -4,	//!< 不正
	kPURequest_TimedOut			= -5,	//!< タイムアウト
	kPURequest_Canceled			= -6,	//!< キャンセル
	
	kPURequest_InvalidData		= -100,	//!< 応答データ不正
};

/**
 *	@brief	HTTPリクエスト
 */
@interface PURequest : NSObject 
{
	CFHTTPMessageRef		m_message;
	CFReadStreamRef			m_replyStream;
	NSMutableDictionary*	m_postData;
	int						m_statusCode;
	NSTimer*				m_timeoutTimer;
	id						m_delegate;
	CFStreamClientContext	m_context;
	NSMutableData*			m_rcvData;
}

-(id) initWithURL:(NSURL*)url withMethod:(NSString*)method;

/**
 *	@param	initialData		POSTに渡す値群
 *	@note	基本は form名(key:NSString) とその値(value:NSString)
 *			アップロードファイルの場合には辞書(value:NSDictionary)を指定
 *			->	ファイルURL:	key=KEY_URL,	value=NSURL
 *				MIME type:		key=KEY_TYPE,	value=NSString
 */
-(id) initWithURL:(NSURL*)url withMethod:(NSString*)method postData:(NSDictionary*)initialData;

/**
 *	@brief	開始
 */
-(void) start;

/**
 *	@brief	キャンセル
 */
-(void) cancel;

/**
 *	@brief	HTTPステータスコード
 *	@note	負値の場合は kPURequest_xxx のどれか
 */
-(int) statusCode;

/**
 *	@brief	応答データ
 *	@note	データの形式などは各要求の仕様に準ずる
 */
-(id) responseData:(NSError**)error;

-(id) delegate;
-(void) setDelegate:(id)delegate;

+(void) setUsername:(NSString*)username;
+(NSString*) username;
+(void) setPassword:(NSString*)password;
+(NSString*) password;

@end

/**
 *	@brief	デリゲート
 */
@interface NSObject (PURequestDelegate)

/**
 *	@brief	完了通知
 *	@param	request		リクエスト
 *	@param	result		結果（statusCodeで取得できるものと同一）
 */
-(void) request:(PURequest*)request didCompletedWithResult:(int)code;
@end
