//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import <Cocoa/Cocoa.h>

#define SERVICE_ACCOUNT			@"account"
#define SERVICE_PASSWORD		@"password"
#define SERVICE_ALBUM			@"album"
#define SERVICE_PHOTO_TITLE		@"title"
#define SERVICE_PHOTO_KEYWORD	@"keyword"
#define SERVICE_PHOTO_COMMENT	@"comment"

@class PUServiceSpec;
@class PUServiceParam;
@class PURequest;
@class PUPhoto;

/**
 *	@brief	写真共有サービスプロトコル
 */
@protocol PUService

/**
 *	@brief	サービスタイトル
 */
-(NSString*) title;

/**
 *	@brief	activeに
 */
-(void) activate;

/**
 *	@brief	非activeに
 */
-(void) deactivate;

/**
 *	@brief	アップロードリクエストの配列を生成
 *	@param	photos	PUPhotoの配列
 *	@return	PURequestの配列
 */
-(NSArray*) requestsWithPhotos:(NSArray*)photos;

/**
 *	@brief	アップロードリクエスト生成
 *	@note	アルバムとの関連付けまでを行う
 */
-(PURequest*) createRequest:(PUPhoto*)photo;

/**
 *	@brief	画像変換用の情報
 */
-(NSDictionary*) convertAttributes;

/**
 *	@brief	アップロード確認用のURL取得
 *	@param	responses	[PURequest responseData]の配列
 *	@return	一般的には画像1枚の場合は画像のURL, 複数枚の場合は関連するアルバムのURL
 */
-(NSURL*) URLForLastUpload:(NSArray*)responses;

/**
 *	@brief	ログイン処理
 *	@note	アルバムを取得したりする（サービスによっては何もしない）
 */
-(void) login;

/**
 *	@brief	認証確認
 *	@note	パスワードなどの入力確認
 */
-(BOOL) checkAuth;

/**
 *	@brief	設定CustomView
 */
-(NSView*) customView;

@end

/**
 *	@brief	写真共有サービス親クラス
 *	@note	keychain 経由のアカウント管理はこのクラスで行う
 */
@interface PUService : NSObject <PUService>
{
	BOOL		m_activated;
	
	PUServiceSpec*	_spec;
	PUServiceParam*	_param;
	NSArray*		_albums;
	
	IBOutlet id o_view;
}

@end
