//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#import "NSURLRequest-ex.h"
#import "NSData-Base64Extensions.h"
#import "NSString-Base64Extensions.h"

@implementation NSMutableURLRequest (PhotoUploader)

-(void) setBasicHeaderWithUsername:(NSString*)username andPassword:(NSString*)password
{
	NSData* baseData = STR_TO_DATA(([NSString stringWithFormat:@"%@:%@", username, password]));
	NSString* baseStr = [baseData encodeBase64];//stringEncodedWithBase64];
	[self setValue:[NSString stringWithFormat:@"Basic %@", baseStr] forHTTPHeaderField:@"Authorization"];	
}

-(void) setMultiPartDataWithDictionary:(NSDictionary*)dict andBoundary:(NSString*)boundary
{
	NSMutableData* data = [[NSMutableData alloc] init];

    id key;
    NSEnumerator* enume = [dict keyEnumerator];
    while (key = [enume nextObject]) {
        id value = [dict valueForKey:key];
//		NSLog(@"%@ : %@", key, value);
        [data appendData:STR_TO_DATA(([NSString stringWithFormat:@"--%@\r\n", boundary]))];
        if ([value isKindOfClass:[NSString class]]) {
			// 文字列
            [data appendData:STR_TO_DATA(([NSString stringWithFormat:@"Content-Disposition: form-data; name=\"%@\"\r\n\r\n", key]))];
            [data appendData:STR_TO_DATA((value))];
        } else if ([value isKindOfClass:[NSDictionary class]]) {
			// 辞書
			id url = [value objectForKey:KEY_URL];
			id type = [value objectForKey:KEY_TYPE];
			if (url && type && 
				[url isKindOfClass:[NSURL class]] && [url isFileURL] && 
				[type isKindOfClass:[NSString class]] && [type length] > 0) {
				[data appendData:STR_TO_DATA(([NSString stringWithFormat:@"Content-Disposition: form-data; name=\"%@\"; filename=\"%@\"\r\n", key, [[url path] lastPathComponent]]))];
				[data appendData:STR_TO_DATA(([NSString stringWithFormat:@"Content-Type: %@\r\n\r\n", type]))];
//				[data appendData:STR_TO_DATA(([NSString stringWithString:@"Content-Type: image/jpeg\r\n\r\n"]))];
				[data appendData:[NSData dataWithContentsOfURL:url]];
//				[data appendData:[NSData dataWithContentsOfFile:[url path]]];
			}
		}
		[data appendData:STR_TO_DATA(([NSString stringWithString:@"\r\n"]))];
    }
    [data appendData:STR_TO_DATA(([NSString stringWithFormat:@"--%@--\r\n", boundary]))];
//	NSLog(@"%@", [[[[NSString alloc] initWithData:data encoding:NSASCIIStringEncoding] autorelease] description]);

	[self addValue:[NSString stringWithFormat:@"multipart/form-data; boundary=%@", boundary] forHTTPHeaderField: @"Content-type"];
	[self setHTTPBody:data];
	[data release];
}

@end
