//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "FlickrService.h"
#import "Flickr.h"
#import "PUCommon.h"

#define	AUTH_WEB_ARG	\
	[NSDictionary dictionaryWithObjectsAndKeys: \
		[FlickrSignature apiKey],	@"api_key", \
		_frob,						@"frob", \
		@"write",					@"perms", \
		nil]

@implementation FlickrService

-(id) init
{
	if (self = [super init]) {
		[NSBundle loadNibNamed:@"Flickr" owner:self];

		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.account"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.password"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.album"];
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.title"];
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.keyword"];
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.comment"];
		
		[self setValue:@"Flickr" forKeyPath:@"param.saveKey"];

		[self setValue:
		 [NSArray arrayWithObjects:
		  [NSNumber numberWithInt:kPUImageFormat_Jpeg], 
		  [NSNumber numberWithInt:kPUImageFormat_Png], 
		  [NSNumber numberWithInt:kPUImageFormat_Gif], 
		  nil] 
			forKeyPath:@"spec.formats"];
	}
	return self;
}

-(void) dealloc
{
	[super dealloc];
}

-(IBAction) authorization:(id)sender
{
	int ret;
	if ([_authBtnTitle isEqualTo:LOCALIZED(@"Login...")]) {
		if (!IS_NULL_STR(_frob)) {
			// frob 取得済み
			ret = NSRunAlertPanel(LOCALIZED(@"iPhotoUpload requires your authorization before it can upload your photos to Flickr"), LOCALIZED(@"Authorizing is a simple process which takes place in your web browser. When you're finished, return to this window to complete authorization"), LOCALIZED(@"Authorize..."), LOCALIZED(@"Cancel"), @"");
			if (ret == NSAlertDefaultReturn) {
				// 認証用URLを生成
				NSString* path = [FlickrRequest createPath:@"http://www.flickr.com/services/auth/" withArgs:AUTH_WEB_ARG needSignature:YES];
				NSURL* url = [NSURL URLWithString:path];
				// ブラウザで開く
				[[NSWorkspace sharedWorkspace] openURL:url];
				
				ret = NSRunAlertPanel(LOCALIZED(@"Return to this window after you have finished the authorization process on Flickr.com"), LOCALIZED(@"Once you're done, click the 'Complete Authorization' button below and you can begin using iPhotoUploader"), LOCALIZED(@"Complete Authorization"), LOCALIZED(@"Cancel"), @"");
				if (ret == NSAlertDefaultReturn) {
					// token 取得
					Flickr_Auth_GetToken* req = [[Flickr_Auth_GetToken alloc] initWithFrob:_frob];
					[req setDelegate:self];
					[req start];
					
					[self setValue:[NSNumber numberWithBool:NO] forKey:@"enableButton"];
				}
			}
		}
	} else {
		ret = NSRunAlertPanel(LOCALIZED(@"Do you logout really?"), LOCALIZED(@"It is necessary to remove permission of iPhotoUploader on Flickr.com. You need to login again if you want to upload to Flickr"), LOCALIZED(@"Open Filckr.com"), LOCALIZED(@"Cancel"), @"");
		if (ret == NSAlertDefaultReturn) {
			[[NSWorkspace sharedWorkspace] openURL:[NSURL URLWithString:@"http://flickr.com/services/auth/list.gne?from=extend"]];
			ret = NSRunAlertPanel(LOCALIZED(@"Return to this window after you have finished the remove process on Flickr.com"), LOCALIZED(@"Once you're done, click the 'Complete Remove' button below"), LOCALIZED(@"Complete Remove"), LOCALIZED(@"Cancel"), @"");
			if (ret == NSAlertDefaultReturn) {
				PUUserDefaults* defaults = [PUUserDefaults standardUserDefaults];
				[defaults removeObjectForKey:@"Flickr_Token"];
				[defaults synchronize];
				[FlickrRequest setToken:nil];
				
				[self setValue:LOCALIZED(@"Login...") forKey:@"authBtnTitle"];
				
				// frobを再取得
				[self login];
			}
		}
	}
}

-(void) request:(PURequest*)request didCompletedWithResult:(int)code
{
	if ([request isKindOfClass:[FlickrRequest class]]) {
		NSError* err = nil;
		NSXMLDocument* xml = [request responseData:&err];
		if (err || !xml) {
			if (err) {
				NSRunAlertPanel([NSString stringWithFormat:LOCALIZED(@"Error Occurred : error code %d"), [err code]], [err localizedDescription], LOCALIZED(@"OK"), @"", @"");
			} else {
				NSRunAlertPanel(LOCALIZED(@"Unknown Error Occurred"), @"", LOCALIZED(@"OK"), @"", @"");				
			}
			[request release];
			return;
		}
//		NSLog(@"%@", [xml description]);
		if ([request isKindOfClass:[Flickr_Auth_GetFrob class]]) {
			// frob 取得
			if (xml && [xml isKindOfClass:[NSXMLDocument class]]) {
				[self setValue:[[xml rootElement] objectValueForXPath:@"/rsp/frob" error:nil] forKey:@"frob"];
			}
			[self setValue:[NSNumber numberWithBool:YES] forKey:@"enableButton"];
		} else if ([request isKindOfClass:[Flickr_Auth_GetToken class]]) {
			// token 取得
			if (xml && [xml isKindOfClass:[NSXMLDocument class]]) {
				[self setValue:[[xml rootElement] objectValueForXPath:@"/rsp/auth/token" error:nil] forKey:@"token"];
				PUUserDefaults* defaults = [PUUserDefaults standardUserDefaults];
				[defaults setObject:_token forKey:@"Flickr_Token"];
				[defaults synchronize];
				[FlickrRequest setToken:_token];
				[self setValue:LOCALIZED(@"Logout...") forKey:@"authBtnTitle"];
			}
			[self setValue:[NSNumber numberWithBool:YES] forKey:@"enableButton"];
		}
	}
		
	[request release];
}

#pragma mark ___ PUService protocol ___

-(NSString*) title
{
	return LOCALIZED(@"Flickr");
}

-(PURequest*) createRequest:(PUPhoto*)photo
{
	return [[[Flickr_Upload alloc] init] autorelease];
}

-(NSDictionary*) convertAttributes
{
	return nil;
}

-(NSURL*) URLForLastUpload:(NSArray*)responses
{
	NSString* path = nil;
	if (responses && [responses count] > 0) {
		NSEnumerator* enume = [responses objectEnumerator];
		id photo;
		NSMutableString* ids = [NSMutableString string];
		while (photo = [enume nextObject]) {
			if ([photo isKindOfClass:[FLPhoto class]]) {
				if ([ids length] > 0) {
					[ids appendString:@","];
				}
				[ids appendFormat:@"%@", [photo valueForKey:@"photoid"]];
			}
		}
		if ([ids length] > 0) {
			path = [NSString stringWithFormat:@"http://www.flickr.com/tools/uploader_edit.gne?ids=%@", ids];
		}
	} else {
	}
	if (path) {
		return [NSURL URLWithString:path];
	}
	return nil;
}

-(void) login
{
	PUUserDefaults* defaults = [PUUserDefaults standardUserDefaults];
	id token = [defaults objectForKey:@"Flickr_Token"];
	if (token) {
		// token取得済み
		[self setValue:token forKey:@"token"];
		[FlickrRequest setToken:_token];
		[self setValue:LOCALIZED(@"Logout...") forKey:@"authBtnTitle"];
		[self setValue:[NSNumber numberWithBool:YES] forKey:@"enableButton"];
	} else {
		// token未取得
		// frob を取得しておく
		Flickr_Auth_GetFrob* req = [[Flickr_Auth_GetFrob alloc] init];
		[req setDelegate:self];
		[req start];
		[self setValue:LOCALIZED(@"Login...") forKey:@"authBtnTitle"];
		[self setValue:[NSNumber numberWithBool:NO] forKey:@"enableButton"];
	}
}

-(BOOL) checkAuth
{
	return (!IS_NULL_STR(_token));
}

@end
