//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "Mixi_Service.h"
#import "MXAlbum.h"
#import "NSXMLElement-ex.h"

@implementation Mixi_Service

-(id) init
{
	if (self = [super initWithURL:[NSURL URLWithString:MIXI_REST_PATH(@"r=3")] withMethod:@"GET"]) {
	}
	return self;
}

-(id) responseData:(NSError**)error
{
	NSXMLDocument* xml = [super responseData:error];
	if (!xml || *error) {
		if (!*error) {
			*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];
		}
		return xml;
	}
	if ([xml isKindOfClass:[NSXMLDocument class]]) {
		NSError* err = nil;
		NSMutableArray* albums = [NSMutableArray array];
		NSArray* nodes = [[xml rootElement] nodesForXPath:@"/service/workspace/collection" error:&err];
		if (!err) {
			if (nodes) {
				NSEnumerator* enume = [nodes objectEnumerator];
				NSXMLElement* collection;
				while (collection = [enume nextObject]) {
					if ([collection nodeForXPath:@"accept" error:nil]) {
						MXAlbum* album = [[MXAlbum alloc] init];
						[album setValue:[collection attributeValueForName:@"href"] forKey:@"href"];
						[album setValue:[collection objectValueForXPath:@"atom:title" error:nil] forKey:@"title"];
						[albums addObject:album];
						[album release];
					}
				}
				*error = nil;
				return albums;
			} else {
				*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];				
			}
		} else {
			*error = err;
		}
	} else {
		*error = [NSError errorWithDomain:PURequestErrorDomain code:kPURequest_InvalidData userInfo:nil];
	}
	return nil;
}

@end
