//	Copyright (c) 2008 itok ( http://itok.jp/ , http://110k.net/ )
//	All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without modification, 
//	are permitted provided that the following conditions are met:
//
//	- Redistributions of source code must retain the above copyright notice, 
//	  this list of conditions and the following disclaimer.
//	- Redistributions in binary form must reproduce the above copyright notice, 
//	  this list of conditions and the following disclaimer in the documentation 
//	  and/or other materials provided with the distribution.
//	- Neither the name of itok nor the names of its contributors may be used to endorse 
//	  or promote products derived from this software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS 
//	AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
//	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY 
//	AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
//	IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
//	INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
//	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
//	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
//	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
//	STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
//	EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "TwitterService.h"
#import "TWRequest.h"
#import "PUCommon.h"


@implementation TwitterService

-(id) init
{
	if (self = [super init]) {
		[NSBundle loadNibNamed:@"Twitter" owner:self];
		
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.account"];
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.password"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.album"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.title"];
		[self setValue:[NSNumber numberWithBool:NO] forKeyPath:@"spec.keyword"];
		[self setValue:[NSNumber numberWithBool:YES] forKeyPath:@"spec.comment"];
		
		[self setValue:[NSURL URLWithString:@"http://twitpic.com/"] forKeyPath:@"param.keychainURL"];
		[self setValue:@"twitter" forKeyPath:@"param.saveKey"];
		
		[self setValue:
		 [NSArray arrayWithObjects:
		  [NSNumber numberWithInt:kPUImageFormat_Jpeg], 
		  [NSNumber numberWithInt:kPUImageFormat_Png],
		  nil] 
			forKeyPath:@"spec.formats"];
	}
	return self;
}

#pragma mark ___ PUService protocol ___

-(NSString*) title
{
	return LOCALIZED(@"twitter");
}

-(PURequest*) createRequest:(PUPhoto*)photo
{
	TWRequest* req = [[[TWRequest alloc] init] autorelease];
	[req setValue:[self valueForKey:@"param"] forKey:@"serviceParam"];
	[req setValue:[o_message stringValue] forKey:@"message"];
	return req;
}

-(NSDictionary*) convertAttributes
{
	return nil;
}

-(NSURL*) URLForLastUpload:(NSArray*)responses
{
	return [NSURL URLWithString:[responses objectAtIndex:0]];
}

-(void) login
{
	// do nothing
}


@end
