@echo off
pushd "%~dp0"
call _setenv.bat

SET VSYEAR=2010
SET VSVER=vs2010

if not exist "%ANGELSCRIPT_ROOT%" goto error
if not exist "%ANGELSCRIPT_SDK_ROOT%" goto error

SET ANGELSCRIPT_LIB=%ANGELSCRIPT_SDK_ROOT%\lib

rem rh
call "%BAT_TOOLS_ROOT%\msbuildvars.bat" %VSVER%

cd "%ANGELSCRIPT_SDK_ROOT%"
if errorlevel 1 goto error

cd projects
if errorlevel 1 goto error

cd msvc%VSMAJOR%
if errorlevel 1 goto error

SET PROJECT_NAME=angelscript

rem build

rem MD
rem x86
msbuild /p:Configuration=Debug		/p:Platform=Win32	/t:Rebuild	%PROJECT_NAME%.sln
if errorlevel 1 goto error
msbuild /p:Configuration=Release	/p:Platform=Win32	/t:Rebuild	%PROJECT_NAME%.sln
if errorlevel 1 goto error

rem x64
msbuild /p:Configuration=Debug		/p:Platform=x64		/t:Rebuild	%PROJECT_NAME%.sln
rem if errorlevel 1 goto error
msbuild /p:Configuration=Release	/p:Platform=x64		/t:Rebuild	%PROJECT_NAME%.sln
rem if errorlevel 1 goto error

@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_md%VSYEAR%.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%d.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_md%VSYEAR%d.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%64.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_md%VSYEAR%_x64.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%64d.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_md%VSYEAR%_x64d.lib"

rem MT
@echo | sed -e "s/<RuntimeLibrary>MultiThreadedDebugDLL</<RuntimeLibrary>MultiThreadedDebug</g" %PROJECT_NAME%.vcxproj  > %PROJECT_NAME%.tmp
@echo | sed -e "s/<RuntimeLibrary>MultiThreadedDLL</<RuntimeLibrary>MultiThreaded</g" %PROJECT_NAME%.tmp > %PROJECT_NAME%-mt.vcxproj
del %PROJECT_NAME%.tmp

rem x86
msbuild /p:Configuration=Debug		/p:Platform=Win32	/t:Rebuild	%PROJECT_NAME%-mt.vcxproj
if errorlevel 1 goto error
msbuild /p:Configuration=Release	/p:Platform=Win32	/t:Rebuild	%PROJECT_NAME%-mt.vcxproj
if errorlevel 1 goto error

rem x64
msbuild /p:Configuration=Debug		/p:Platform=x64		/t:Rebuild	%PROJECT_NAME%-mt.vcxproj
rem if errorlevel 1 goto error
msbuild /p:Configuration=Release	/p:Platform=x64		/t:Rebuild	%PROJECT_NAME%-mt.vcxproj
rem if errorlevel 1 goto error

@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%.lib"		"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_mt%VSYEAR%.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%-mtd.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_mt%VSYEAR%d.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%64.lib"		"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_mt%VSYEAR%_x64.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%-mt64d.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_mt%VSYEAR%_x64d.lib"

:clean
del /F /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%.lib"
del /F /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%-mtd.lib"
del /F /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%64.lib"
del /F /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%-mt64d.lib"

popd

goto end

:error
pause

:end
