@echo off
pushd "%~dp0"
call _setenv.bat
SET VSVERSION=2010
SET PATH=%WINDIR%\Microsoft.NET\Framework\v4.0.30319;%PATH%
SET TARGETDIR=%TEMPDIR%\%APPNAME%

cd %TEMPDIR%
if not exist %APPNAME% goto error
cd %APPNAME%

if exist zconf.h (
	if not exist zconf.h.bak (
		rename zconf.h zconf.h.bak
	) else (
		rm -rf zconf.h
	)
)
cd ..\

if not exist build mkdir build
cd build
if not exist %APPNAME% mkdir %APPNAME%
cd %APPNAME%
if not exist vs%VSVERSION% mkdir vs%VSVERSION%
cd vs%VSVERSION%

SET BUILD_DIR=%TEMPDIR%build\%APPNAME%\vs%VSVERSION%

rem zlib path
SET ZLIB_INCLUDE_DIR=%TEMPDIR%zlib

cmake -G "Visual Studio 10" %TARGETDIR%
if errorlevel 1 goto error

msbuild /p:Configuration=Release	/p:Platform=Win32	/t:Clean;Build	%TEMPDIR%\build\%APPNAME%\vs%VSVERSION%\%APPNAME%.sln

cd %TEMPDIR%\%APPNAME%
if exist zconf.h.bak (
	if not exist zconf.h (
		rename zconf.h.bak zconf.h
	)
)

popd
rem filesync.bat %VCDIR% msvc10 %VSVERSION%

:error
popd
pause

:end
