//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		ceil_test.cpp
 * @brief		ceil_test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_ceil_test_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "platform/windows/win/base/WXCurrentDirectory.h"
#include "platform/windows/win/io/WXFindFile.h"
#include "platform/windows/win/os/WXProcess.h"
#include "platform/windows/win/shell/WXShellPath.h"
#include "platform/windows/win/shell/WXSHExecute.h"
#include "iris_iostream.h"
#include "iris_using.h"
#include <tchar.h>

TEST(AllroundTest, all)
{
	CPath path;
	::GetModuleFileName(::GetModuleHandle(nullptr), path, path.GetLength());
	CPath name = path.FindFileName();
	path.RemoveFileSpec();
	CCurrentDirectory cd;
	cd.Push(path);
	
	CStartupInfo si;
	si.UseStdHandles();

	CFindFile find;
	if( find.FindFirst(IRIS_TEXT("./*.exe")) )
	{
		do
		{
			if( _tcsstr(find->cFileName, name) != nullptr ) continue;
			std::tcout << find->cFileName << std::endl;
			CProcess proc;
			TCHAR cmd[256] = TEXT("");
			ASSERT_FALSE( proc.RunWait<TCHAR>(find->cFileName, cmd, nullptr, nullptr, FALSE, 0, nullptr, nullptr, si) );
		} while( find.FindNext() );
	}
}

