//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_bits.cpp
 * @brief		FndBits eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_bits_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndBits.h"
#include "iris_using.h"

TEST(FndBitsTest, Func)
{
	CBitsFlag<64> bits;
	bits[0] = 0xFFFFFFFF;
	bits[1] = 0x00000000;

	for( int i=0; i < 32; ++i )
	{
		ASSERT_TRUE( bits.IsFlag(i) );
	}
	for( int i=0; i < 32; ++i )
	{
		ASSERT_FALSE( bits.IsFlag(i+32) );
	}

	bits.DisableFlag(6);
	ASSERT_FALSE( bits.IsFlag(6) );
	bits.EnableFlag(1, 6);
	ASSERT_TRUE( bits.IsFlag(1, 6) );
}
