//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_duration.cpp
 * @brief		FndDuration eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_duration_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndDuration.h"
#include "iris_using.h"
#include "iris_iostream.h"

TEST(FndDurationTest, Func)
{
	CDuration<int, iml::mega> d(100);

	ASSERT_EQ( 100, d.count() );
	ASSERT_EQ( 101, (++d).count() );
	ASSERT_EQ( 101, (d++).count() );
	ASSERT_EQ( 102, d.count() );

	ASSERT_EQ( 101, (--d).count() );
	ASSERT_EQ( 101, (d--).count() );
	ASSERT_EQ( 100, d.count() );

	ASSERT_EQ( 200, (d*2).count() );
	ASSERT_EQ(  50, (d/2).count() );
	ASSERT_EQ(   1, (d%9).count() );

	d *= 2;
	ASSERT_EQ( 200, d.count() );
	d /= 2;
	ASSERT_EQ( 100, d.count() );
	d %= 9;
	ASSERT_EQ(   1, d.count() );
	d = CDuration<int, iml::mega>(100);
	ASSERT_EQ( 100, d.count() );
	d %= CDuration<int, iml::mega>(9);
	ASSERT_EQ(   1, d.count() );
}

