//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_list.cpp
 * @brief		FndList eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_list_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndList.h"
#include "iris_using.h"

typedef CListNode<int>	Node;
typedef CList<Node>		List;

TEST(FndListTest, ConstTest)
{
	List list;
	int v[10] =
	{
		1,
		2,
		5,
		9,
		4,
		6,
		0,
		8,
		7,
		3
	};
	Node node[10];
	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		node[i] = v[i];
	}

	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		list.push_back(node+i);
	}

	List::iterator it = list.begin();
	ASSERT_EQ( TRUE, it != list.end() );

	for( int i=0; i < IRIS_NumOfElements(node); ++i, ++it )
	{
		int tmp = *(*it);
		ASSERT_EQ( v[i], tmp );
	}

	it = list.back();
	for( int i=0; i < IRIS_NumOfElements(node); ++i, --it )
	{
		int tmp = *(*it);
		ASSERT_EQ( v[IRIS_NumOfElements(node)-i-1], tmp );
	}
}

TEST(FndListTest, foreach)
{
	List list;
	int v[10] =
	{
		1,
		2,
		5,
		9,
		4,
		6,
		0,
		8,
		7,
		3
	};
	Node node[10];
	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		node[i] = v[i];
	}

	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		list.push_back(node+i);
	}


	struct tester
	{
		static int* list(void)	{ static int a[10] = {0}; return a; }
		static int*	ptr(void)	{ static int* p = list(); return p++; }
		void operator () (const Node& x) { *ptr() = *x; }
	};

	list.foreach(tester());

	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		ASSERT_EQ( v[i], tester::list()[i] );
	}
}

TEST(FndListTest, sort)
{
	List list;
	int v[10] =
	{
		1,
		2,
		5,
		9,
		4,
		6,
		0,
		8,
		7,
		3
	};
	Node node[10];
	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		node[i] = v[i];
	}

	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		list.push_back(node+i);
	}

	list.sort();

	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		ASSERT_EQ( i, *(*list[i]) );
	}

	list.sort(CGreaterOp());

	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		ASSERT_EQ( 10-i-1, *(*list[i]) );
	}
}