//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_sort.cpp
 * @brief		sort eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_test_sort_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndSort.h"
#include "iris_iostream.h"
#include "iris_using.h"
#include <time.h>
#include <vector>

//======================================================================
// typedef
typedef u32	test_type;

//======================================================================
// define
//#define TEST_NUM		10000000	// eXg
//#define TEST_NUM		99999		// eXg
#define TEST_NUM		8192		// eXg
//#define TEST_NUM		2000000		// eXg

//======================================================================
// class
template<typename SORT>
class FndSortFunctionTest : public ::testing::Test
{
protected:
	static const int COUNT = TEST_NUM;
protected:
	test_type raw_table[COUNT];
	test_type sort_table[COUNT];
protected:
	typedef SORT	CSort;
protected:
	template<typename T>
	void	Cout(T& ary, int SIZE)
	{
		const int LINE_ELEM = 4;			// 1s̕\
		for( int i=0, n=0, sz=(SIZE+LINE_ELEM-1)/LINE_ELEM; i < sz; ++i ) 
		{
			for( int j=0; j < LINE_ELEM && n < SIZE; ++j, ++n )	
				std::cout << "0x" << std::hex << std::setw(8) << std::setfill('0') << ary[n] << ", ";
			std::cout << std::endl;
		}
		std::cout << std::endl;
	};

	virtual void SetUp() 
	{
		// e[u쐬
		for( int i=0; i < COUNT; ++i )
			raw_table[i] = sort_table[i] = rand();
	}
	virtual void TearDown()
	{
	}
};

#if TEST_NUM < 10000
typedef ::testing::Types<CSelectionSort
						, CBubbleSort
						, CInsertSort
						, CHeapSort
						, CCombSort
						, CShellSort
						, CMergeSort
						, CQuickSort
						, CIntroSort
						> SortClassTypes;
#else
typedef ::testing::Types<CCombSort
						, CQuickSort
						, CIntroSort
						> SortClassTypes;
#endif
TYPED_TEST_CASE(FndSortFunctionTest, SortClassTypes);

TYPED_TEST(FndSortFunctionTest, RandomTableSort)
{
	CSort::Sort(sort_table, COUNT, CLessOp());
	for( int i=0; i < COUNT-1; ++i ) 
	{
		ASSERT_LE( sort_table[i], sort_table[i+1] );
	}
}

TYPED_TEST(FndSortFunctionTest, FixedTableSort)
{
	for( int i=0; i < COUNT; ++i )
		sort_table[i] = i;
	CSort::Sort(sort_table, COUNT, CLessOp());
	for( int i=0; i < COUNT-1; ++i ) 
	{
		ASSERT_LE( sort_table[i], sort_table[i+1] );
	}
}

TYPED_TEST(FndSortFunctionTest, ReverseOrderTableSort)
{
	for( int i=0; i < COUNT; ++i )
		sort_table[i] = COUNT-i;
	CSort::Sort(sort_table, COUNT, CLessOp());
	for( int i=0; i < COUNT-1; ++i ) 
	{
		ASSERT_LE( sort_table[i], sort_table[i+1] );
	}
}

TYPED_TEST(FndSortFunctionTest, DISABLED_PartSort)
{
	// I𕔕݂̂̃\[g
	s32 begin = rand() % COUNT / 2 + 1;
	s32 end = rand() % (COUNT-begin-1) + 1 + begin;
	CSort::Sort(sort_table, begin, end, CLessOp());

	int i=0;
	for( ; i < begin; ++i ) 
	{
		ASSERT_EQ( sort_table[i], raw_table[i] );
	}
	for( ; i < end-1; ++i ) 
	{
		ASSERT_LE( sort_table[i], sort_table[i+1] );
	}
	for( i = end; i < COUNT; ++i ) 
	{
		ASSERT_EQ( sort_table[i], raw_table[i] );
	}
}
