//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_operator.cpp
 * @brief		FndOperator eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_operator_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/operator/FndVaugeOp.h"
#include "iris_using.h"
#include "iris_debug.h"

#include "c++0x/cpp0x_type_traits.hpp"

// FndOperator eXg
// opposite
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp, CVaugeFalseOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp, CVaugeTrueOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp, CVaugeNotEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp, CVaugeGEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp, CVaugeGreaterOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp, CVaugeLEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp, CVaugeLessOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp, CVaugeEqualOp::opposite>::value) );

// append
// CVaugeFalseOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeFalseOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeTrueOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeEqualOp>::type, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeLessOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeLEqualOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeGreaterOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeGEqualOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::append<CVaugeNotEqualOp>::type, CVaugeNotEqualOp>::value) );

// CVaugeTrueOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeFalseOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeTrueOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeEqualOp>::type, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeLessOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeLEqualOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeGreaterOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeGEqualOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::append<CVaugeNotEqualOp>::type, CVaugeNotEqualOp>::value) );

// CVaugeEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeFalseOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeTrueOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeEqualOp>::type, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeLessOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeLEqualOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeGreaterOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeGEqualOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::append<CVaugeNotEqualOp>::type, CVaugeTrueOp>::value) );

// CVaugeLessOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeFalseOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeTrueOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeEqualOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeLessOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeLEqualOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeGreaterOp>::type, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeGEqualOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::append<CVaugeNotEqualOp>::type, CVaugeLessOp>::value) );

// CVaugeLEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeFalseOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeTrueOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeEqualOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeLessOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeLEqualOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeGreaterOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeGEqualOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::append<CVaugeNotEqualOp>::type, CVaugeLessOp>::value) );

// CVaugeGreaterOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeFalseOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeTrueOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeEqualOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeLessOp>::type, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeLEqualOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeGreaterOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeGEqualOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::append<CVaugeNotEqualOp>::type, CVaugeGreaterOp>::value) );

// CVaugeGEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeFalseOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeTrueOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeEqualOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeLessOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeLEqualOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeGreaterOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeGEqualOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::append<CVaugeNotEqualOp>::type, CVaugeGreaterOp>::value) );

// CVaugeNotEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeFalseOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeTrueOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeEqualOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeLessOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeLEqualOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeGreaterOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeGEqualOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::append<CVaugeNotEqualOp>::type, CVaugeNotEqualOp>::value) );

// erase
// CVaugeFalseOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeFalseOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeTrueOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeEqualOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeLessOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeLEqualOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeGreaterOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeGEqualOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeFalseOp::erase<CVaugeNotEqualOp>::type, CVaugeFalseOp>::value) );

// CVaugeTrueOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeFalseOp>::type, CVaugeTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeTrueOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeEqualOp>::type, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeLessOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeLEqualOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeGreaterOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeGEqualOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeTrueOp::erase<CVaugeNotEqualOp>::type, CVaugeEqualOp>::value) );

// CVaugeEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeFalseOp>::type, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeTrueOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeEqualOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeLessOp>::type, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeLEqualOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeGreaterOp>::type, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeGEqualOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeEqualOp::erase<CVaugeNotEqualOp>::type, CVaugeEqualOp>::value) );

// CVaugeLessOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeFalseOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeTrueOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeEqualOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeLessOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeLEqualOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeGreaterOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeGEqualOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLessOp::erase<CVaugeNotEqualOp>::type, CVaugeLEqualOp>::value) );

// CVaugeLEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeFalseOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeTrueOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeEqualOp>::type, CVaugeLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeLessOp>::type, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeLEqualOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeGreaterOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeGEqualOp>::type, CVaugeLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeLEqualOp::erase<CVaugeNotEqualOp>::type, CVaugeLEqualOp>::value) );

// CVaugeGreaterOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeFalseOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeTrueOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeEqualOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeLessOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeLEqualOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeGreaterOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeGEqualOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGreaterOp::erase<CVaugeNotEqualOp>::type, CVaugeGEqualOp>::value) );

// CVaugeGEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeFalseOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeTrueOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeEqualOp>::type, CVaugeGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeLessOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeLEqualOp>::type, CVaugeGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeGreaterOp>::type, CVaugeEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeGEqualOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeGEqualOp::erase<CVaugeNotEqualOp>::type, CVaugeGEqualOp>::value) );

// CVaugeNotEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeFalseOp>::type, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeTrueOp>::type, CVaugeFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeEqualOp>::type, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeLessOp>::type, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeLEqualOp>::type, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeGreaterOp>::type, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeGEqualOp>::type, CVaugeNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CVaugeNotEqualOp::erase<CVaugeNotEqualOp>::type, CVaugeFalseOp>::value) );

//======================================================================
// test
TEST(FndVaugeOperatorTest, Func)
{
	// bool
	ASSERT_FALSE( CVaugeFalseOp()(0, 0) );
	ASSERT_FALSE( CVaugeFalseOp()(1, 0) );
	ASSERT_FALSE( CVaugeFalseOp()(0, 1) );

	ASSERT_TRUE(  CVaugeTrueOp()(0, 0) );
	ASSERT_TRUE(  CVaugeTrueOp()(1, 0) );
	ASSERT_TRUE(  CVaugeTrueOp()(0, 1) );

	ASSERT_TRUE ( CVaugeEqualOp()(0, 0) );
	ASSERT_FALSE( CVaugeEqualOp()(1, 0) );
	ASSERT_FALSE( CVaugeEqualOp()(0, 1) );

	ASSERT_FALSE( CVaugeLessOp()(0, 0) );
	ASSERT_FALSE( CVaugeLessOp()(1, 0) );
	ASSERT_TRUE ( CVaugeLessOp()(0, 1) );

	ASSERT_TRUE ( CVaugeLEqualOp()(0, 0) );
	ASSERT_FALSE( CVaugeLEqualOp()(1, 0) );
	ASSERT_TRUE ( CVaugeLEqualOp()(0, 1) );

	ASSERT_FALSE( CVaugeGreaterOp()(0, 0) );
	ASSERT_TRUE ( CVaugeGreaterOp()(1, 0) );
	ASSERT_FALSE( CVaugeGreaterOp()(0, 1) );

	ASSERT_TRUE ( CVaugeGEqualOp()(0, 0) );
	ASSERT_TRUE ( CVaugeGEqualOp()(1, 0) );
	ASSERT_FALSE( CVaugeGEqualOp()(0, 1) );

	ASSERT_FALSE( CVaugeNotEqualOp()(0, 0) );
	ASSERT_TRUE ( CVaugeNotEqualOp()(1, 0) );
	ASSERT_TRUE ( CVaugeNotEqualOp()(0, 1) );

	int vauge = CVaugeGreaterOp()(0, 0);
	if( CVaugeLessOp()(1, 0) )
	{
		ASSERT_TRUE(false);
	}

	// vauge
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeFalseOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeFalseOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeFalseOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeTrueOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeTrueOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeTrueOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeEqualOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeEqualOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeEqualOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_VAUGE, CVaugeLessOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeLessOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeLessOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeLEqualOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeLEqualOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeLEqualOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_VAUGE, CVaugeGreaterOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeGreaterOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeGreaterOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeGEqualOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeGEqualOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeGEqualOp()(0, 1) );

	ASSERT_EQ( IrisVaugeBool::VB_FALSE, CVaugeNotEqualOp()(0, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeNotEqualOp()(1, 0) );
	ASSERT_EQ( IrisVaugeBool::VB_TRUE , CVaugeNotEqualOp()(0, 1) );
}

