//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_color.cpp
 * @brief		FndColor eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_color_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/image/FndBitmap.h"
#include "iris_using.h"

TEST(FndBitmapTest, Info)
{
	CBitmap bmp;
	ASSERT_TRUE( bmp.ReadFile(TEXT("../../../../data/image/sample.bmp")) );

	ASSERT_TRUE( bmp.IsValid() );
	ASSERT_TRUE( bmp.CheckFile() );
	ASSERT_EQ( 320, bmp.GetWidth() );
	ASSERT_EQ( 240, bmp.GetHeight() );
	ASSERT_EQ( 24, bmp.GetBitCount() );
	ASSERT_EQ( 320*240*3, bmp.GetImageSize() );
	ASSERT_EQ( 0, bmp.GetPalleteNum() );
	ASSERT_EQ( 0, bmp.GetPalleteSize() );
}

