//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_yuv.cpp
 * @brief		FndYuv eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_color_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/image/FndYUV.h"
#include "iris_using.h"

typedef testing::Types< CYCbCr<>, CYPbPr<> > YUVTypeParams;

template<typename YUV>
class FndYUVTest : public testing::TestWithParam<YUV>
{
};

TYPED_TEST_CASE(FndYUVTest, YUVTypeParams);

TYPED_TEST(FndYUVTest, toRGB)
{
	ParamType yuv(CCOLORREF(0x33, 0xFF, 0xFF));
	CCOLORREF color = yuv;
	ASSERT_NEAR(0x33, color.r(), 10);
	ASSERT_NEAR(0xFF, color.g(), 10);
	ASSERT_NEAR(0xFF, color.b(), 10);
}

