//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_baseencoding.cpp
 * @brief		FndBaseEncoding eXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_baseencoding_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/charcode/FndBaseEncoding.h"
#include "iris_using.h"

#define BUF_LEN			256
#define BUF_BASELEN		(BUF_LEN)*2+1

#define TEST_CODE(enc)	do {					\
	static const TCHAR buf[] = TEXT("test");	\
	TCHAR base[BUF_BASELEN];					\
	TCHAR out[BUF_LEN];							\
	CBaseEncoding<eBASE64>::Encode(base, BUF_BASELEN, (u8*)buf, sizeof(buf));			\
	CBaseEncoding<eBASE64>::Decode((u8*)out, BUF_LEN*sizeof(TCHAR), base, BUF_BASELEN);	\
	ASSERT_STREQ( buf, out );					\
} while(0)

TEST(FndBaseEncodingTest, Base16)
{
	TEST_CODE(eBASE16);
}

TEST(FndBaseEncodingTest, Base32)
{
	TEST_CODE(eBASE32);
}

TEST(FndBaseEncodingTest, Base32Hex)
{
	TEST_CODE(eBASE32_HEX);
}

TEST(FndBaseEncodingTest, Base64)
{
	TEST_CODE(eBASE64);
}
