//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_fixedfloat.cpp
 * @brief		FndFixedFloat eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_fixedfloat_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/format/FndFixedFloat.h"
#include "iris_using.h"

TEST(FndFixedFloatTest, cast)
{
	CFixedFloat<u32, 19, 12> fx1;
	CFixedFloat<u16,  3, 12> fx2;
	fx1 = 0.124f;
	fx2 = fx1;
	ASSERT_FLOAT_EQ( (float)fx1, (float)fx2 );
	ASSERT_EQ( 0, (int)fx1 );
}

TEST(FndFixedFloatTest, substitution)
{
	CFixedFloat<u32, 19, 12> fx;
	fx = 1;
	ASSERT_EQ( fx.ONE, fx.value() );
	fx = 0.1f;
}


