//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iml_algorithm.cpp
 * @brief		iml_algorithm.hpp eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_iml_algorithm_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "c++0x/cpp0x_type_traits.hpp"
#include "ml/iml_algorithm.hpp"
#include "iris_using.h"

#define TEST_NUM 100000
TEST(iml_algorithmTest, swap)
{
	for( int i=0; i < TEST_NUM; ++i )
	{
		int x=123, y=0x456789AB;
		iml::swap(x, y);
		ASSERT_EQ( 0x456789AB, x );
		ASSERT_EQ( 123, y );
	}
}

TEST(iml_algorithmTest, swap2)
{
	for( int i=0; i < TEST_NUM; ++i )
	{
		int x=123, y=0x456789AB;
		swap(x, y);
		ASSERT_EQ( 0x456789AB, x );
		ASSERT_EQ( 123, y );
	}
}

class iterator_begin_end_Test : public testing::Test
{
public:
	static const int SIZE = 2;
public:
	struct func
	{
		int i;
		int a[2];
		func(void) : i(0) {}
		void operator ()(int v)
		{
			a[i++] = v;
		}
	};
};

TEST_F(iterator_begin_end_Test, stl)
{
	std::vector<int> v;
	for( int i=0; i < SIZE; ++i )
	{
		v.push_back(i);
	}

	func f;
	iml::foreach(iml::iterator_begin(v), iml::iterator_end(v), f);
	for( int i=0; i < SIZE; ++i )
	{
		ASSERT_EQ(f.a[i], i);
	}
}

TEST_F(iterator_begin_end_Test, Array)
{
	int v[SIZE] = {1, 2};
	for( int i=0; i < SIZE; ++i )
	{
		v[i] = i;
	}

	func f;
	iml::foreach(iml::iterator_begin(v), iml::iterator_end(v), f);
	for( int i=0; i < SIZE; ++i )
	{
		ASSERT_EQ(f.a[i], i);
	}
	printf("%d\n", __cplusplus);
}

#if defined(__cplusplus0x)

TEST(foreach_Test, stl)
{
	std::vector<int> v;
	for( int i=0; i < 10; ++i )
	{
		v.push_back(i);
	}

	iml::foreach(iml::iterator_begin(v), iml::iterator_end(v), [](int a) { prinf("%d\n", a); });
}
#endif

//#define TESTu32
TEST(iml_algorithmTest, prime_number)
{
	ASSERT_TRUE( iml::is_prime_number<2>::value );
	ASSERT_TRUE( iml::is_prime_number<3>::value );
	ASSERT_TRUE( iml::is_prime_number<5>::value );
	ASSERT_TRUE( iml::is_prime_number<7>::value );
	ASSERT_TRUE( iml::is_prime_number<13>::value );
	ASSERT_TRUE( iml::is_prime_number<1049>::value );
	ASSERT_TRUE( iml::is_prime_number<2003>::value );
	ASSERT_TRUE( iml::is_prime_number<3023>::value );
	ASSERT_TRUE( iml::is_prime_number<5507>::value );
	ASSERT_TRUE( iml::is_prime_number<10091>::value );
	ASSERT_TRUE( iml::is_prime_number<18701>::value );
	ASSERT_TRUE( iml::is_prime_number<65497>::value );
#ifdef TESTu32
	ASSERT_TRUE( iml::is_prime_number<1048573>::value );
	ASSERT_TRUE( iml::is_prime_number<4256233>::value );
	ASSERT_TRUE( iml::is_prime_number<16777213>::value );
	ASSERT_TRUE( iml::is_prime_number<268435399>::value );
	//ASSERT_TRUE( iml::is_prime_number<1073741789>::value );
#endif

	ASSERT_FALSE( iml::is_prime_number<-10>::value );
	ASSERT_FALSE( iml::is_prime_number<0>::value );
	ASSERT_FALSE( iml::is_prime_number<1>::value );
	ASSERT_FALSE( iml::is_prime_number<1057>::value );
	ASSERT_FALSE( iml::is_prime_number<18707>::value );
	ASSERT_FALSE( iml::is_prime_number<65499>::value );
#ifdef TESTu32
	//ASSERT_FALSE( iml::is_prime_number<268435397>::value );
#endif
}

