//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_tfpu_vec2.cpp
 * @brief		MathTVector2 eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_tfpu_vec2_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/tfpu/MathTVector2.h"
#include "iris_using.h"

TEST(MathTVector2Test, Zero)
{
#define ZEROTEST(type, zero)	do {	\
		typedef IrisTVec2<type> vec2;	\
		vec2 vec;						\
		TFpuVec2Zero(&vec);				\
		ASSERT_EQ( zero, vec.x );		\
		ASSERT_EQ( zero, vec.y );		\
	} while(0)

	ZEROTEST(int	, 0);
	ZEROTEST(float	, 0.f);
	ZEROTEST(double	, 0.0);
#undef ZEROTEST
}

TEST(MathTVector2Test, Copy)
{
#define COPYTEST(type)			do {	\
		typedef IrisTVec2<type> vec2;	\
		vec2 v1, v2;					\
		TFpuVec2Copy(&v1, &v2);			\
		ASSERT_EQ( v1.x, v2.x );		\
		ASSERT_EQ( v1.y, v2.y );		\
	} while(0)

	COPYTEST(int);
	COPYTEST(float);
	COPYTEST(double);
#undef COPYTEST
}

TEST(MathTVector2Test, PositiveZero)
{
#define ZEROTEST(type, zero)	do {	\
		typedef IrisTVec2<type> vec2;	\
		vec2 vec;						\
		TFpuVec2PositiveZero(&vec);		\
		ASSERT_EQ( zero, vec.x );		\
		ASSERT_EQ( zero, vec.y );		\
	} while(0)

	ZEROTEST(int	, 0);
	ZEROTEST(float	, 0.f);
	ZEROTEST(double	, 0.0);
#undef ZEROTEST
}
