//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_sortarray.cpp
 * @brief		CSortArray eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_sortarray_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "platform/windows/mfc/container/MfcSortArray.h"
#include "iris_using.h"

typedef CSortArray<int, fnd::CVaugeLessOp> SortArray;

TEST(MfcSortArrayTest, Add)
{
	SortArray sa;
	int n = ((rand() >> 8) & 0xFF) + 1;
	for( int i=0; i < n; ++i )
	{
		sa.Add(rand());
	}

	int pre = sa[0];
	for( int i=1; i < n; ++i )
	{
		ASSERT_LE(pre, sa[i]);
		pre = sa[i];
	}
}

TEST(MfcSortArrayTest, SetAt)
{
	SortArray sa;
	int n = ((rand() >> 8) & 0xFF) + 1;
	for( int i=0; i < n; ++i )
	{
		sa.Add(rand());
	}

	int pre = sa[0];
	for( int i=1; i < n; ++i )
	{
		ASSERT_LE(pre, sa[i]);
		pre = sa[i];
	}

	for( int i=0; i < n; ++i )
	{
		sa.SetAt(i, rand());
	}

	pre = sa[0];
	for( int i=1; i < n; ++i )
	{
		ASSERT_LE(pre, sa[i]);
		pre = sa[i];
	}
}
