//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		main.cpp
 * @brief		test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "web/nacl/core/NaclModule.h"
#include "web/nacl/core/NaclError.h"
#include "web/nacl/debug/NaclDebug.h"
#include "web/nacl/object/NaclScriptableObj.h"
#include "web/nacl/object/NaclMethod.h"
#include "web/nacl/fs/NaclFile.h"
#include "iris_using.h"
#include <algorithm>

namespace test
{

class TestInstance : public CInstance<TestInstance>
{
	typedef CInstance<TestInstance>	_Mybase;
	CFileSystem		m_fs;
public:
	explicit TestInstance(PP_Instance instance)
		: _Mybase(instance)
		, m_fs(this, PP_FILESYSTEMTYPE_LOCALPERSISTENT)
	{
		printf("Initialize TestScriptableObject.\n");
		AddMethod("writeFile", CMethodFactory::CreateMethod(this, &TestInstance::writeFile));

		int32_t hr = m_fs.Open(4096);
		if( hr != PP_OK_COMPLETIONPENDING )
		{
			PostMessage("ERROR: Could not open local persistent file system.");
		}
	}

public:
	pp::Var	writeFile(std::string buf)
	{
		nacl::CFile		m_file(this, m_fs);
		if( m_file.Open("/test", fnd::FOPEN_RW | fnd::FOPEN_CREATE) )
		{
			int32_t ret = m_file.Write(buf.c_str(), buf.length());
			PostMessage(buf);
			return ret;
		}
		return true;
	}
};

}

// Gg|Cg̋Lq
typedef CModule<test::TestInstance>	Module;
static CModuleEntry<Module> s_module_entry;

#if 1
namespace pp
{

Module* CreateModule() 
{
	if( IModuleEntry::GetInstancePtr() == nullptr ) return nullptr;
	return IModuleEntry::GetInstance().CreateInstance();
}

}
#endif
