
/*
 * is not available vprintf, can be replaced.
*/
//#define IUTEST_VPRINTF

/*
 * include testing framework
*/
#include "iutest.hpp"

#if 1	// Success Tests

struct Bar
{
	int x, y, z;
};

::std::ostream& operator << (::std::ostream& os, const Bar& bar) 
{
	return os << "X:" << bar.x << " Y:" << bar.y << " Z:" << bar.z;
}

void PrintTo(const Bar& bar, ::std::ostream* os)
{
	*os << "x:" << bar.x << " y:" << bar.y << " z:" << bar.z;
}

IUTEST(SubTest, Test1)
{
	std::vector<int> a;
	for( int i=0; i < 10; ++i )
		a.push_back(i);
	IUTEST_SUCCEED() << ::iutest::PrintToString(a);
}

IUTEST(SubTest, Test2)
{
	int* p;
	Bar bar = {0, 1, 2};
	IUTEST_SUCCEED() << ::iutest::PrintToString(bar);
	IUTEST_SUCCEED() << ::iutest::PrintToString(p);
}

class SubTestFixed : public iutest::Test
{
protected:
	static int x;
public:
	virtual void SetUp(void)
	{
		++x;
	}
	static void SetUpTestCase(void)
	{
		x = 0;
	}
};
int SubTestFixed::x = -1;

IUTEST_F(SubTestFixed, Test1)
{
	IUTEST_ASSERT_EQ(1, x);
}

IUTEST_F(SubTestFixed, Test2)
{
	IUTEST_ASSERT_EQ(2, x);
}

#if IUTEST_HAS_PARAM_TEST
// p[^eXg

class SubTestP : public iutest::TestWithParam<int>
{
protected:
	static int a;
	static int b;
public:
	static void SetUpTestCase(void)
	{
		a = 0;
		b = 0;
	}
};
int SubTestP::a = 0;
int SubTestP::b = 0;

IUTEST_INSTANTIATE_TEST_CASE_P(SubTestPInstance, SubTestP, iutest::Range<int>(0, 10, 2));

IUTEST_P(SubTestP, TestA)
{
	IUTEST_ASSERT_EQ(a, GetParam());
	a+=2;
}

IUTEST_P(SubTestP, TestB)
{
	IUTEST_ASSERT_EQ(b, GetParam());
	b+=2;
}

#endif

struct Obj
{
	Obj	operator ++ (int v)
	{
		IUTEST_SUCCEED() << "What is the value of the dummy argument? A. " << v;
		return Obj();
	}
};

IUTEST(IncTest, After)
{
	Obj o;
	o++;
}

#endif
