//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		prime.cpp
 * @brief		prime t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "web/nacl/core/NaclModule.h"
#include "web/nacl/object/NaclScriptableObj.h"
#include "web/nacl/object/NaclMethod.h"
#include "iris_using.h"
#include <algorithm>

#include "math/MathPrimeNumber.h"

namespace prime
{

typedef bool (*PFN_isPrime)(int32_t number);
bool isPrime(int32_t number)
{
	return iris::math::IsPrimeNumber(number);
}

class TestInstance : public CInstance<TestInstance>
{
	typedef CInstance<TestInstance>	_Mybase;
public:
	TestInstance(PP_Instance instance)
		: _Mybase(instance)
	{
		printf("Initialize HashScriptableObject.\n");
		AddMethod("isPrime", CMethodFactory::CreateMethod(isPrime));
		AddMethod("isPrime", CMethodFactory::CreateMethod(iris::math::IsPrimeNumber));
	}
};

}

// Gg|Cg̋Lq
typedef iris::nacl::CModule<prime::TestInstance>	Module;
static iris::nacl::CModuleEntry<Module> s_module_entry;

#if 1
namespace pp
{

Module* CreateModule() 
{
	if( iris::nacl::IModuleEntry::GetInstancePtr() == nullptr ) return nullptr;
	return iris::nacl::IModuleEntry::GetInstance().CreateInstance();
}

}
#endif
