//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test.cpp
 * @brief		test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "web/nacl/core/NaclModule.h"
#include "web/nacl/core/NaclError.h"
#include "web/nacl/debug/NaclDebug.h"
#include "web/nacl/object/NaclScriptableObj.h"
#include "web/nacl/object/NaclMethod.h"
#include "iris_using.h"
#include <algorithm>

namespace test
{

class TestInputHandler : public IInputHandler
{
public:
	virtual bool OnMouseEvent(const pp::MouseInputEvent& rEvent, PP_InputEvent_Type type)
	{
		OutputDebugVar(rEvent.GetPosition().x());
		OutputDebugVar(rEvent.GetPosition().y());
		return IInputHandler::OnMouseEvent(rEvent, type);
	}
	virtual bool OnKeyboardEvent(const pp::KeyboardInputEvent& rEvent, PP_InputEvent_Type type)
	{
		OutputDebugVar(rEvent.GetKeyCode());
		return IInputHandler::OnKeyboardEvent(rEvent, type);
	}
};

class TestInstance : public CInstance<TestInstance>
{
	typedef CInstance<TestInstance>	_Mybase;
	TestInputHandler	m_Input;
public:
	explicit TestInstance(PP_Instance instance)
		: _Mybase(instance)
	{
		printf("Initialize TestScriptableObject.\n");
		RequestInputEvents(PP_INPUTEVENT_CLASS_MOUSE | PP_INPUTEVENT_CLASS_WHEEL);
		RequestFilteringInputEvents(PP_INPUTEVENT_CLASS_KEYBOARD);
		SetInputHandler(&m_Input);
	}
};

}

// Gg|Cg̋Lq
typedef CModule<test::TestInstance>	Module;
static CModuleEntry<Module> s_module_entry;

#if 1
namespace pp
{

Module* CreateModule() 
{
	if( IModuleEntry::GetInstancePtr() == nullptr ) return nullptr;
	return IModuleEntry::GetInstance().CreateInstance();
}

}
#endif
