//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test.cpp
 * @brief		test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "web/nacl/core/NaclModule.h"
#include "web/nacl/core/NaclError.h"
#include "web/nacl/debug/NaclDebug.h"
#include "web/nacl/object/NaclScriptableObj.h"
#include "web/nacl/object/NaclMethod.h"
#include "web/nacl/fs/NaclFile.h"
#include "web/nacl/audio/NaclAudio.h"
#include "audio/format/riff/AXWavFile.h"
#include "iris_using.h"
#include <algorithm>

namespace test
{

class TestInputHandler : public IInputHandler
{
public:
	virtual bool	OnKeyDown(pp::KeyboardInputEvent& rEvent)
	{
		OutputDebugVar(rEvent.GetKeyCode());
		return true;
	}
};

class TestInstance : public CInstance<TestInstance>
{
	typedef CInstance<TestInstance>	_Mybase;
	CFileSystem		m_fs;
	CWavFile		m_wav;
	pp::AudioConfig	m_config;
	CAudio			m_sound;
	TestInputHandler	m_Input;
public:
	explicit TestInstance(PP_Instance instance)
		: _Mybase(instance)
		, m_fs(this, PP_FILESYSTEMTYPE_LOCALPERSISTENT)
		, m_config(this, PP_AUDIOSAMPLERATE_44100, pp::AudioConfig::RecommendSampleFrameCount(PP_AUDIOSAMPLERATE_44100, 4096))
		, m_sound(this, m_config)
	{
		printf("Initialize TestScriptableObject.\n");
		AddMethod("fileSystem", CMethodFactory::CreateMethod(this, &TestInstance::fileSystemDemo));
		AddMethod("startSound", CMethodFactory::CreateMethod(this, &TestInstance::startSound));
		AddMethod("stopSound" , CMethodFactory::CreateMethod(this, &TestInstance::stopSound));

		RequestInputEvents(PP_INPUTEVENT_CLASS_MOUSE);
		SetInputHandler(&m_Input);
		m_sound.SetFile(&m_wav);
	}

public:
	pp::Var	fileSystemDemo(void)
	{
		int32_t hr = m_fs.Open(4096);
		if( NACL_SUCCEEDED(hr) )
		{
			nacl::CFile		m_file(this, m_fs);
			if( m_file.Open("test.txt", fnd::FOPEN_READ) )
			{
				char buf[1024];
				int32_t ret = m_file.Read(buf, 1024);
				OutputDebugVar(buf);
				return ret;
			}
		}
		return FormatMessage(hr);
	}

	bool	startSound(void)
	{
		if( !m_wav.IsOpen() )
		{
			if( !m_wav.Open("./sample.wav") )
			{
				OutputDebugVar("file open faild.");
				return false;
			}
		}
		return m_sound.Start();
	}

	bool	stopSound(void)
	{
		return m_sound.Stop();
	}
};

}

// Gg|Cg̋Lq
typedef CModule<test::TestInstance>	Module;
static CModuleEntry<Module> s_module_entry;

#if 1
namespace pp
{

Module* CreateModule() 
{
	if( IModuleEntry::GetInstancePtr() == nullptr ) return nullptr;
	return IModuleEntry::GetInstance().CreateInstance();
}

}
#endif
