//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_bbshub.cpp
 * @brief		test_bbshub t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_bbshub_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/random/RndBBShub.h"
#include "math/random/RndEvaluater.h"
#include "iris_iostream.h"
#include "iris_using.h"

typedef CBBShubRand	CTestRandom;

TEST(BBShubTest, Generate)
{
	CTestRandom rnd;
	rnd.SetSeed(2);
	u32 r1 = rnd.GenRand32();
	ASSERT_NE(r1, rnd.GenRand32());
	rnd.SetSeed(1);
	ASSERT_NE(r1, rnd.GenRand32());
	rnd.SetSeed(2);
	ASSERT_EQ(r1, rnd.GenRand32());
}

TEST(BBShubTest, MonoTest)
{
	CTestRandom gen;
	CEvaluater eval(&gen);
	int x = 0;
	EXPECT_TRUE( eval.MonoTest(&x) );

	std::cout << x << std::endl;
}

TEST(BBShubTest, Equiprobability)
{
	CTestRandom gen;
	CEvaluater eval(&gen);
	f32 x = 0;
	EXPECT_TRUE( eval.Equiprobability(&x) );

	std::cout << x << std::endl;
}

