//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_xorshift.cpp
 * @brief		test_xorshift t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_xorshift_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/random/RndXOR.h"
#include "math/random/RndEvaluater.h"
#include "iris_iostream.h"
#include "iris_using.h"

typedef CXorShift	CTestRandom;

TEST(XorShiftTest, Generate)
{
	CTestRandom rnd;
	rnd.SetSeed(2);
	u32 r1 = rnd.GenRand32();
	ASSERT_NE(r1, rnd.GenRand32());
	rnd.SetSeed(1);
	ASSERT_NE(r1, rnd.GenRand32());
	rnd.SetSeed(2);
	ASSERT_EQ(r1, rnd.GenRand32());
}

TEST(XorShiftTest, MonoTest)
{
	CTestRandom gen;
	CEvaluater eval(&gen);
	int x = 0;
	EXPECT_TRUE( eval.MonoTest(&x) );

	std::cout << x << std::endl;
}

TEST(XorShiftTest, Equiprobability)
{
	CTestRandom gen;
	CEvaluater eval(&gen);
	f32 x = 0;
	EXPECT_TRUE( eval.Equiprobability(&x) );

	std::cout << x << std::endl;
}

