//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_privateprofile.cpp
 * @brief		privateprofile eXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_privateprofile_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "platform/windows/win/registry/WXPrivateProfile.h"
#include "iris_using.h"
#include <tchar.h>

TEST(WXPrivateProfileTest, WriteRead)
{
	// wirte
	{
		CPrivateProfile pp;
		pp.Open(TEXT(".\\test.ini"));

		ASSERT_TRUE( pp.WriteSection(TEXT("TEST"), TEXT("SECTION=0")) );

		ASSERT_TRUE( pp.WriteString(TEXT("TEST"), TEXT("TEXT"), TEXT("test123")) );
		ASSERT_TRUE( pp.WriteInt(TEXT("TEST"), TEXT("INT"), 345) );
		ASSERT_TRUE( pp.WriteFloat(TEXT("TEST"), TEXT("FLOAT"), 1.2345678f) );
		ASSERT_TRUE( pp.WriteHex(TEXT("TEST"), TEXT("HEX"), 0xABCDEF01) );
	}
	// read
	{
		CPrivateProfile pp;
		pp.Open(TEXT(".\\test.ini"));

		TCHAR name[256];
		ASSERT_EQ( 5, pp.GetSectionNames(name, 256) );
		ASSERT_TRUE( pp.GetSection(TEXT("TEST"), name, 256) );

		ASSERT_TRUE( pp.GetString(TEXT("TEST"), TEXT("TEXT"), TEXT("FAILED"), name, 256) );
		ASSERT_STREQ( TEXT("test123"), name );
		ASSERT_EQ( 345, pp.GetInt(TEXT("TEST"), TEXT("INT"), 0) );
		ASSERT_FLOAT_EQ( 1.2345678f, pp.GetFloat(TEXT("TEST"), TEXT("FLOAT"), 0.0f) );
		ASSERT_EQ( 0xABCDEF01, pp.GetHex(TEXT("TEST"), TEXT("HEX"), 0x0) );
	}
	// remove
	{
		CPrivateProfile pp;
		pp.Open(TEXT(".\\test.ini"));

		ASSERT_TRUE( pp.RemoveKey(TEXT("TEST"), TEXT("INT")) );

		TCHAR name[256];
		ASSERT_EQ( 5, pp.GetSectionNames(name, 256) );
		ASSERT_TRUE( pp.GetSection(TEXT("TEST"), name, 256) );

		ASSERT_TRUE( pp.GetString(TEXT("TEST"), TEXT("TEXT"), TEXT("FAILED"), name, 256) );
		ASSERT_STREQ( TEXT("test123"), name );
		ASSERT_EQ( 0, pp.GetInt(TEXT("TEST"), TEXT("INT"), 0) );
		ASSERT_FLOAT_EQ( 1.2345678f, pp.GetFloat(TEXT("TEST"), TEXT("FLOAT"), 0.0f) );
		ASSERT_EQ( 0xABCDEF01, pp.GetHex(TEXT("TEST"), TEXT("HEX"), 0x0) );

		pp.Remove();
		ASSERT_EQ( 0, pp.GetSectionNames(name, 256) );
	}
}

