//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_safearray.cpp
 * @brief		safearray eXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_safearray_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "platform/windows/win/container/WXSafeArray.h"
#include "iris_iostream.h"
#include "iris_global.h"
#include "iris_using.h"
#include <tchar.h>

#define TEST_NUM	5

TEST(SafearrayTest, Info)
{
	CSafeArray<int> sa(TEST_NUM);

	ASSERT_EQ( sizeof(int), sa.elem_size() );
	ASSERT_EQ( TEST_NUM, sa.size() );
	ASSERT_EQ( VT_INT, sa.VT );
	ASSERT_EQ( 1, sa.dim() );
	//ASSERT_EQ( 0, sa.lbound() );
	//ASSERT_EQ( TEST_NUM-1, sa.ubound() );
}

TEST(SafearrayTest, Assgin)
{
	CSafeArray<int> sa(TEST_NUM);

	for( int i=0; i < TEST_NUM; ++i )
	{
		sa.assign(i, i);
	}

	for( int i=0; i < TEST_NUM; ++i )
	{
		ASSERT_EQ(i, sa.get(i));
	}
}

TEST(SafearrayTest, Elem)
{
	CSafeArray<int> sa(TEST_NUM);

	ASSERT_EQ( sizeof(int), sa.elem_size() );
	ASSERT_EQ( TEST_NUM, sa.size() );
	ASSERT_EQ( VT_INT, sa.VT );

	{
		CSafeArray<int>::CElement elem = sa.data();
		for( int i=0; i < TEST_NUM; ++i )
		{
			elem[i] = i;
		}
	}

	for( int i=0; i < TEST_NUM; ++i )
	{
		ASSERT_EQ(i, sa.get(i));
	}
}

TEST(SafearrayTest, Operator)
{
	CSafeArray<int> sa(TEST_NUM);

	ASSERT_EQ( sizeof(int), sa.elem_size() );
	ASSERT_EQ( TEST_NUM, sa.size() );
	ASSERT_EQ( VT_INT, sa.VT );

	for( int i=0; i < TEST_NUM; ++i )
	{
		sa[i] = i;
	}

	for( int i=0; i < TEST_NUM; ++i )
	{
		ASSERT_EQ(i, sa[i]);
	}
}
