//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALBuffer.h
 * @brief		OpenAL obt@NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXALBuffer_H_
#define INCG_IRIS_AXALBuffer_H_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "../../fnd/container/FndObserver.h"
#include "AXALTypes.h"

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// class
/**
 * @ingroup	OpenAL
 * @brief	OpenALobt@NX
*/
class CALBuffer : public fnd::CObserver<CALBuffer>
{
protected:
	AXALU32	m_Buffer;	//!< obt@

public:
	// RXgN^
	CALBuffer(void);
	// fXgN^
	virtual ~CALBuffer(void);

public:
	// 
	bool	Initialize(void);
	// 
	void	Release(void);

public:
	// obt@̍쐬
	bool	Create(void);
	// obt@̍폜
	void	Delete(void);

public:
	// g`obt@̓o^
	void	BindData(LPAXALVOID pData, AXALSIZEI uSize, AXALS32 nChannel, AXALSIZEI freq);
	// alobt@Ɋ֘At
	void	BindDataStatic(LPAXALVOID pData, AXALSIZEI uSize, AXALS32 nChannel, AXALSIZEI freq);

public:
	// obt@Lǂ
	bool	IsValid(void)	const;
	//! vC[ɓo^Ă邩
	bool	IsRegistPlayer(void)	const	{ return (GetSubject() != nullptr); }

public:
	//! obt@̎擾
	AXALU32	GetBuffer(void)		const	{ return m_Buffer; }
	// g̎擾
	AXALS32	GetFrequency(void)	const;
	// f[^TCY̎擾
	AXALS32	GetSize(void)		const;
	// 1Tṽrbg̎擾
	AXALS32	GetBits(void)		const;
	// `l̎擾
	AXALS32	GetChannels(void)	const;

public:
	// wrap
	void	seti (AXALENUM param, AXALS32 value);
	void	setf (AXALENUM param, AXALF32 value);
	void	set3i(AXALENUM param, AXALS32 v1, AXALS32 v2, AXALS32 v3);
	void	set3f(AXALENUM param, AXALF32 v1, AXALF32 v2, AXALF32 v3);
	void	setiv(AXALENUM param, const AXALS32* values);
	void	setfv(AXALENUM param, const AXALF32* values);

	void	geti (AXALENUM param, AXALS32* value)	const;
	void	getf (AXALENUM param, AXALF32* value)	const;
	void	get3i(AXALENUM param, AXALS32* v1, AXALS32* v2, AXALS32* v3)	const;
	void	get3f(AXALENUM param, AXALF32* v1, AXALF32* v2, AXALF32* v3)	const;
	void	getiv(AXALENUM param, AXALS32* values)	const;
	void	getfv(AXALENUM param, AXALF32* values)	const;
};

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#endif

#endif
