//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALContext.cpp
 * @brief		OpenAL ReLXg NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXALContext_CPP_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "AXALContext.h"

//======================================================================
// link
#ifdef _WIN32
#  pragma comment ( lib, "OpenAL32.lib" )
#endif

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// class
// CALContext

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CALContext::CALContext(void)
: m_pContext(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	lpContext	= ֘AtReLXg
*//***********************************************************************/
CALContext::CALContext(LPAXALCCONTEXT lpContext)
: m_pContext(lpContext)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CALContext::~CALContext(void)
{
	Release();
}

/**********************************************************************//**
 *
 * ֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	lpContext	= ֘AtReLXg
 * @return	
*//***********************************************************************/
bool CALContext::Attach(LPAXALCCONTEXT lpContext)
{
	if( m_pContext != nullptr ) return false;
	m_pContext = lpContext;
	return true;
}

/**********************************************************************//**
 *
 * ֘At
 *
 ----------------------------------------------------------------------
 * @return	ȑÕReLXg
*//***********************************************************************/
LPAXALCCONTEXT CALContext::Detach(void)
{
	LPAXALCCONTEXT pContext = m_pContext;
	m_pContext = nullptr;
	return pContext;
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpDevice	= foCX̃|C^
 * @return	
*//***********************************************************************/
bool CALContext::Create(LPAXALCDEVICE lpDevice, LPCAXALCONTEXTATTR lpCntxAttr)
{
	int* pAttr = nullptr;
	int attr[12] = { 0 };

	if( lpCntxAttr != nullptr )
	{
		int index = 0;
		if(lpCntxAttr->fMask & AXAL_CAF_FREQUENCY)
		{
			attr[index ++] = ALC_FREQUENCY;
			attr[index ++] = lpCntxAttr->nFrequency;
		}
		if(lpCntxAttr->fMask & AXAL_CAF_REFRESH)
		{
			attr[index ++] = ALC_REFRESH;
			attr[index ++] = lpCntxAttr->nRefresh;
		}
		if(lpCntxAttr->fMask & AXAL_CAF_SYNC)
		{
			attr[index ++] = ALC_SYNC;
			attr[index ++] = lpCntxAttr->nSync;
		}
		if(lpCntxAttr->fMask & AXAL_CAF_MONO_SOURCES)
		{
			attr[index ++] = ALC_MONO_SOURCES;
			attr[index ++] = lpCntxAttr->nMonoSources;
		}
		if(lpCntxAttr->fMask & AXAL_CAF_STEREO_SOURCES)
		{
			attr[index ++] = ALC_STEREO_SOURCES;
			attr[index ++] = lpCntxAttr->nStereoSources;
		}
		attr[index ++] = 0;
		attr[index ++] = 0;
		pAttr = attr;
	}
	LPAXALCCONTEXT pContext = alcCreateContext(lpDevice, pAttr);
	if( !Attach(pContext) )
	{
		alcDestroyContext(pContext);
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CALContext::Release(void)
{
	LPAXALCCONTEXT pContext = Detach();
	if( pContext != nullptr )
	{
		LPAXALCCONTEXT pCurrent = alcGetCurrentContext();
		if( pContext == pCurrent )
			alcMakeContextCurrent(nullptr);
		alcDestroyContext(pContext);
	}
}

/**********************************************************************//**
 *
 * ReLXgɂ
 *
*//***********************************************************************/
void CALContext::Process(void)
{
	alcProcessContext(m_pContext);
}

/**********************************************************************//**
 *
 * ReLXg~
 *
*//***********************************************************************/
void CALContext::Suspend(void)
{
	alcSuspendContext(m_pContext);
}

/**********************************************************************//**
 *
 * Jgɐݒ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
AXALCBOOL CALContext::MakeCurrent(void)
{
	return alcMakeContextCurrent(m_pContext);
}

/**********************************************************************//**
 *
 * foCX擾
 *
 ----------------------------------------------------------------------
 * @return	foCX
*//***********************************************************************/
LPAXALCDEVICE CALContext::GetDevice(void)
{
	return alcGetContextsDevice(m_pContext);
}

/**********************************************************************//**
 *
 * JgReLXg擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
LPAXALCCONTEXT CALContext::GetCurrent(void)
{
	return alcGetCurrentContext();
}

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "AXALDevice.h"
#include "../../iris_using.h"
#include <stdio.h>

//======================================================================
// test
IRIS_UNITTEST(CAXALContextUnitTest, Func)
{
	CALDevice	device;
	CALContext	context;
	device.Open();
	context.Create(device);
	context.MakeCurrent();
	context.Release();

	context.Create(device);
	context.Process();
	context.Suspend();
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
