//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALContext.h
 * @brief		OpenAL ContextNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXALContext_H_
#define INCG_IRIS_AXALContext_H_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "alc_inchead.h"
#include "../../iris_object.h"
#include "AXALTypes.h"

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// class
/**
 * @ingroup	OpenAL
 * @brief	OpenAL ReLXgNX
*/
class CALContext : public IIrisObject
{
private:
	LPAXALCCONTEXT	m_pContext;	//!< ReLXg
public:
	// RXgN^
	CALContext(void);
	// RXgN^
	CALContext(LPAXALCCONTEXT lpContext);
	// fXgN^
	~CALContext(void);

	/**
	 * @name OpenAL ReLXg ̎擾
	 * @{
	*/
	LPAXALCCONTEXT				GetContext(void)				{ return m_pContext; }
					operator	LPAXALCCONTEXT (void)			{ return GetContext(); }
	LPAXALCCONTEXT	operator	() (void)						{ return GetContext(); }
	CALContext&		operator	= (LPAXALCCONTEXT lpContext)	{ Attach(lpContext); return *this; }
	/**
	 * @}
	*/

public:
	// ֘At
	bool			Attach(LPAXALCCONTEXT lpContext);
	// ֘At
	LPAXALCCONTEXT	Detach(void);

public:
	// 쐬
	bool		Create(LPAXALCDEVICE lpDevice, LPCAXALCONTEXTATTR lpCntxAttr=nullptr);
	// 
	void		Release(void);

public:
	// ReLXgɂ
	void		Process(void);
	// ReLXg~
	void		Suspend(void);

	// Jgɐݒ
	AXALCBOOL	MakeCurrent(void);

public:
	// foCX擾
	LPAXALCDEVICE	GetDevice(void);

public:
	// JgReLXg擾
	static	LPAXALCCONTEXT	GetCurrent(void);
};

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#endif

#endif
