//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALError.cpp
 * @brief		OpenAL Error t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXALError_CPP_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "al_inchead.h"
#include "alc_inchead.h"
#include "AXALError.h"
#include "../../iris_xchar.hpp"

#define AXAL_SWITCH_ERROR_MESSAGE_(text)						\
	switch( Error )												\
	{															\
	case AL_NO_ERROR:											\
		xcscpy_s(lpBuf, size, text("AL_NO_ERROR"));				\
		break;													\
																\
	case AL_INVALID_NAME:										\
		xcscpy_s(lpBuf, size, text("AL_INVALID_NAME"));			\
		break;													\
	case AL_INVALID_ENUM:										\
		xcscpy_s(lpBuf, size, text("AL_INVALID_ENUM"));			\
		break;													\
	case AL_INVALID_VALUE:										\
		xcscpy_s(lpBuf, size, text("AL_INVALID_VALUE"));		\
		break;													\
	case AL_INVALID_OPERATION:									\
		xcscpy_s(lpBuf, size, text("AL_INVALID_OPERATION"));	\
		break;													\
	case AL_OUT_OF_MEMORY:										\
		xcscpy_s(lpBuf, size, text("AL_OUT_OF_MEMORY"));		\
		break;													\
}

#define AXALC_SWITCH_ERROR_MESSAGE_(text)						\
	switch( Error )												\
	{															\
	case ALC_NO_ERROR:											\
		xcscpy_s(lpBuf, size, text("ALC_NO_ERROR"));			\
		break;													\
																\
	case ALC_INVALID_DEVICE:									\
		xcscpy_s(lpBuf, size, text("ALC_INVALID_DEVICE"));		\
		break;													\
	case ALC_INVALID_CONTEXT:									\
		xcscpy_s(lpBuf, size, text("ALC_INVALID_CONTEXT"));		\
		break;													\
	case ALC_INVALID_ENUM:										\
		xcscpy_s(lpBuf, size, text("ALC_INVALID_ENUM"));		\
		break;													\
	case ALC_INVALID_VALUE:										\
		xcscpy_s(lpBuf, size, text("ALC_INVALID_VALUE"));		\
		break;													\
	case ALC_OUT_OF_MEMORY:										\
		xcscpy_s(lpBuf, size, text("ALC_OUT_OF_MEMORY"));		\
		break;													\
}

namespace iris {
namespace ax {
namespace al
{

/**********************************************************************//**
 *
 * G[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	Error	= G[l
 * @param [out]	lpBuf	= o̓obt@
 * @param [in]	size	= o̓obt@TCY
*//***********************************************************************/
template<>
void	AXALFormatMessage<CHAR>(int Error, LPSTR  lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	AXAL_SWITCH_ERROR_MESSAGE_(IRIS_TEXTA);
}
/**
 * @ref	AXALFormatMessage
*/
template<>
void	AXALFormatMessage<WCHAR>(int Error, LPWSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	AXAL_SWITCH_ERROR_MESSAGE_(IRIS_TEXTW);
}

/**********************************************************************//**
 *
 * G[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	Error	= G[l
 * @param [out]	lpBuf	= o̓obt@
 * @param [in]	size	= o̓obt@TCY
*//***********************************************************************/
template<>
void	AXALCFormatMessage<CHAR>(int Error, LPSTR  lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	AXALC_SWITCH_ERROR_MESSAGE_(IRIS_TEXTA);
}
/**
 * @ref	AXALCFormatMessage
*/
template<>
void	AXALCFormatMessage<WCHAR>(int Error, LPWSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	AXALC_SWITCH_ERROR_MESSAGE_(IRIS_TEXTW);
}

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#endif
