//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALSystem.cpp
 * @brief		OpenAL System NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXALSystem_CPP_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "al_inchead.h"
#include "AXALSystem.h"
#include "AXALContext.h"
#include "AXALDevice.h"
#include "../../fnd/utility/FndRefCounter.h"

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// class
namespace
{

class CALSystemImpl : public fnd::CRefCounter
{
public:
	static CALSystemImpl* s_pInstance;

private:
	CALDevice	m_Device;			//<! OpenAL foCX
	CALContext	m_Context;			//<! OpenAL ReLXg

public:
	// RXgN^
	CALSystemImpl(void) {}
	// fXgN^
	~CALSystemImpl(void)
	{
		Release();
	}

public:
	// foCX
	bool	Initialize(const AXALCHAR* deviceSpecifier, LPCAXALCONTEXTATTR lpCntxAttr=nullptr)
	{
		Release();

		if( !m_Device.Open(deviceSpecifier) ) return false;
		if( !m_Context.Create(m_Device, lpCntxAttr) ) return false;
		m_Context.MakeCurrent();
		return true;
	}

	// foCXI
	void	Release(void)
	{
		m_Context.Release();
		m_Device.Close();
	}
};

CALSystemImpl* CALSystemImpl::s_pInstance = nullptr;

}

//======================================================================
// CALSystem::CImpl
class CALSystem::CImpl : public CALSystemImpl
{
};


//======================================================================
// CALSystem

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CALSystem::CALSystem(void)
: m_pImpl(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CALSystem::CALSystem(const CALSystem& rObject)
: m_pImpl(rObject.m_pImpl)
{
	if( m_pImpl != nullptr ) m_pImpl->AddRef();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
CALSystem& CALSystem::operator = ( CALSystem& rObject )
{
	m_pImpl = rObject.m_pImpl;
	if( m_pImpl != nullptr ) m_pImpl->AddRef();
	return *this;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CALSystem::~CALSystem(void)
{
	if( m_pImpl == nullptr ) return;
	m_pImpl->SubRef();
	if( m_pImpl->GetRef() <= 0 )
	{
		IRIS_SAFE_DELETE( CALSystemImpl::s_pInstance );
		m_pImpl = nullptr;
	}
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	CToolHelpCX^X
*//***********************************************************************/
CALSystem CALSystem::CreateImplement(void)
{
	CALSystem ref;
	CImpl* pImpl = static_cast<CImpl*>(CALSystemImpl::s_pInstance);
	if( pImpl == nullptr )
	{
		pImpl = new CImpl;
		CALSystemImpl::s_pInstance = pImpl;
	}
	pImpl->AddRef();
	ref.m_pImpl = pImpl;
	return ref;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	deviceSpecifier	= IvV
 * @return	
*//***********************************************************************/
bool CALSystem::Initialize(LPCAXALSTR deviceSpecifier)
{
	if( m_pImpl == nullptr ) return false;
	return m_pImpl->Initialize(deviceSpecifier);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	deviceSpecifier	= IvV
 * @param [in]	lpCntxAttr		= ReLXg
 * @return	
*//***********************************************************************/
bool CALSystem::InitializeEx(LPCAXALSTR deviceSpecifier, LPCAXALCONTEXTATTR lpCntxAttr)
{
	if( m_pImpl == nullptr ) return false;
	return m_pImpl->Initialize(deviceSpecifier, lpCntxAttr);
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CALSystem::Release(void)
{
	if( m_pImpl == nullptr ) return;
	m_pImpl->Release();
}

/**********************************************************************//**
 *
 * ÕG[R[h擾
 *
 ----------------------------------------------------------------------
 * @return	G[R[h
*//***********************************************************************/
AXALRESULT CALSystem::GetLastError(void)
{
	return alGetError();
}

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "../../fnd/format/FndRIFF.h"
#include "../../fnd/io/FndFile.h"
#include "AXALPlayer.h"
#include "AXALBuffer.h"
#include "../../iris_using.h"
#include <stdio.h>
#include <tchar.h>

//======================================================================
// test
IRIS_UNITTEST(CAXALSystemUnitTest, Func)
{
	CRIFFBuffer<fnd::CFile> riff;
	CALSystem system = CALSystem::CreateImplement();
	CALPlayer player;
	CALBuffer buffer;
	system.Initialize();
	TCHAR fname[MAX_PATH] = IRIS_TEXT("../../../data/snd/sample.wav");

	if( !riff.Open(fname) )
	{
		fprintf(stderr, "file open failed.\n");
		return;
	}
	_ftprintf(stderr, IRIS_TEXT("file open %s.\n"), fname);

	if( riff.GetFormType() != RIFF_FORM_WAVE ) return;
	LPRIFF_CHUNK fmt = riff.FindChunk(RIFF_ID_FMT_CHUNK);
	if( fmt == nullptr ) return;
	LPRIFF_CHUNK data = riff.FindChunk(RIFF_ID_DATA_CHUNK);
	if( data == nullptr ) return;
	u16 channel = *((u16*)fmt->pData + 1);
	u32 freq	= *((u32*)fmt->pData + 1);

	player.Initialize();

	buffer.Initialize();
	buffer.BindData(data->pData, data->Size, channel, freq);
	//buffer.BindDataStatic(data->pData, data->Size, channel, freq);

	player.StreamOut(&buffer, FALSE);
	player.SetLoop(FALSE);
	player.Play();

	while( player.IsPlay() )
	{
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
