//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXAudioBuffer.h
 * @brief		I[fBIobt@ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXAudioBuffer_H_CB012615_F37A_43c0_9367_E89AB3980BF3
#define INCG_IRIS_AXAudioBuffer_H_CB012615_F37A_43c0_9367_E89AB3980BF3

//======================================================================
// include
#include "AXAudioFile.h"
#include "fnd/container/FndBuffer.h"

namespace iris {
namespace ax
{

//======================================================================
// class
/// I[fBIobt@
template< typename Allocator_ = fnd::CNewAllocator<u8> >
class CAXBuffer : public fnd::CBuffer<u8, Allocator_>
{
protected:
	IAXFile*	m_pFile;	//!< t@CNX
	u32			m_ReadSize;	//!< Ǎ݃TCY
public:
	// RXgN^
	CAXBuffer(void) : m_pFile(nullptr), m_ReadSize(0)					{}
	explicit CAXBuffer(IAXFile* pFile) : m_pFile(pFile), m_ReadSize(0)	{}

public:
	/// 
	virtual	void	Initialize(void)	{}

public:
	// f[^̓Ǎ
	virtual	bool	Read(u32 uSize)
	{
		if( m_pFile == nullptr ) return false;
		resize(uSize);
		if( m_pBuffer == nullptr ) return false;
		u32 read = (u32)m_pFile->ReadPCM(m_pBuffer, uSize);
		if( read == 0 ) return false;
		m_ReadSize = read;
		return true;
	}
	virtual	bool	Read(void)
	{
		if( m_pBuffer == nullptr )
		{
			// Sǂ
			return ReadAll();
		}
		return Read(size());
	}


	//! PCM f[^ׂăt@Cǂݍ
	virtual	bool	ReadAll(void)
	{
		if( m_pFile == nullptr ) return false;
		u32 uSize = m_pFile->GetSizePCM();
		return Read(uSize);
	}

public:
	/// t@C̐ݒ
	void		SetFile(IAXFile* pFile)		{ m_pFile = pFile; }
	/// t@C̎擾
	IAXFile*	GetFile(void)				{ return m_pFile; }
	/// Ǎ݃TCY̎擾
	u32			GetReadSize(void)	const	{ return m_ReadSize; }
	/// obt@̎擾
	void*		GetAddr(void)				{ return ptr(); }
	const void*	GetAddr(void)		const	{ return ptr(); }

public:
	/**
	 * @name operator
	 * @{
	*/
	operator	u8*				(void)			{ return ptr(); }
	operator	const u8*		(void)	const	{ return ptr(); }
	operator	void*			(void)			{ return ptr(); }
	operator	const void*		(void)	const	{ return ptr(); }
	/**
	 * @}
	*/
};

}	// end of namespace ax
}	// end of namespace iris

#endif
