//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXOggVorbisError.h
 * @brief		oggG[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXOggVorbisError_H_
#define INCG_IRIS_AXOggVorbisError_H_

#ifdef _IRIS_SUPPORT_OGGVORBIS

//======================================================================
// inculde
#include "../../../iris_inchead.h"
#include "../../../iris_debug.h"
#include "vorbis/vorbisfile.h"

//======================================================================
// define
#define	OV_OK	(0)

namespace iris {
namespace ax
{

//======================================================================
// function
template<typename CHARTYPE_>
void	AXOVFormatMessage (int error, CHARTYPE_* lpBuf, size_t size);

}	// end of namespace ax
}	// end of namespace iris

//======================================================================
// define
#define AXOV_SUCCEEDED(result)			(result == OV_OK)
#define AXOV_FAILED(result)				(result != OV_OK)

#ifdef _IRIS_DEBUG

#define AXOV_ERROR(error)				do { if( AXOV_FAILED(error) ) { TCHAR err_str[256]; iris::ax::AXOVFormatMessage(error, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) :<%s>.\n")  , __LINE__, err_str); } } while(0)
#define AXOV_ERROR2(error, comm)		do { if( AXOV_FAILED(error) ) { TCHAR err_str[256]; iris::ax::AXOVFormatMessage(error, err_str, 256); dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s:<%s>.\n"), __LINE__, comm, err_str); } } while(0)
#define AXOV_CHECK_RESULT(exp)			do { int error = (exp); if( AXOV_FAILED(error) ) {				\
											TCHAR err_str[256]; iris::ax::AXOVFormatMessage(error, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
										} } while(0)
#define AXOV_DO_CHECK_RESULT(exp, todo)	do { int error = (exp); if( AXOV_FAILED(error) ) {				\
											TCHAR err_str[256]; iris::ax::AXOVFormatMessage(error, err_str, 256);	\
											dprintf(TEXT("*** FAILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%s>.\n"), __LINE__, TEXT(#exp), err_str); \
											todo;														\
										} } while(0)

#else

#define AXOV_ERROR(error)				(void)(0)
#define AXOV_ERROR2(error, comm)		(void)(0)
#define AXOV_CHECK_RESULT(exp)			exp
#define AXOV_DO_CHECK_RESULT(exp, todo)	do { if( AXOV_FAILED(exp) ) { todo; } } while(0)

#endif

#endif

#endif
