//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXCdaFile.h
 * @brief		cda t@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXCdaFile_H_
#define INCG_IRIS_AXCdaFile_H_

//======================================================================
// inculde
#include "../AXAudioFile.h"
#include "../../../fnd/container/FndFileBuffer.h"
#include "../../../fnd/io/FndFile.h"

#if defined(_IRIS_SUPPORT_WDK)
#include "../../../platform/windows/win/drive/WXCDDrive.h"
#include "../../../fnd/format/FndCDDA.h"

namespace iris {
namespace ax
{

//======================================================================
// class
/**
 * @brief	cda t@CNX
 * @note	Windows ȊOT|[g
*/
class CCdaFile : public IAXFile
{
	typedef fnd::CFileBuffer<fnd::CFile>	FILE;

protected:
	wx::CCDDrive			m_File;			//!< t@C
	fnd::CCDDAFile<FILE>	m_Format;		//!< tH[}bg
	u32						m_Size;			//!< f[^TCY
	u32						m_SectorIndex;	//!< ݂̃ZN^΃CfbNX
	u32						m_SectorSize;	//!< hCũZN^TCY

public:
	static const u32	SAMPLING_RATE			= 44100;	//!< TvO[g
	static const u16	BITS_WIDTH				= 16;		//!< PTvrbgTCY
	static const u16	CHANNELS				= 2;		//!< `l

public:
	// RXgN^
	CCdaFile(void);
	// fXgN^
	virtual ~CCdaFile(void);

public:
	// J
	virtual	bool	OpenA(LPCSTR  fname) override;
	virtual	bool	OpenW(LPCWSTR fname) override;
	virtual bool	IsOpen(void)	const;

	// 
	virtual	void	Close(void) override;

public:
	// PCMf[^̓ǂݎ
	virtual u32		ReadPCM(void* lpBuffer, u32 size);

	// WAVEFORMATEX̎擾
	virtual bool	GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const;

	/// fmt`N̎擾
	const fnd::CDDA_FMT_CHUNK&	GetFormatChunk(void)	const	{ return m_Format; }
	/// f[^̃TCY擾
	virtual	u32		GetSize(void)		const	{ return m_Size; }
	/// PCMf[^TCY̎擾
	virtual u32		GetSizePCM(void)	const	{ return m_Size; }
public:
	// tell
	virtual s32		Tell(void)	const;
	// tell time
	virtual f64		TellTime(void)	const;
	// seek
	virtual	bool	Seek(s32 samples);
	// seek (time)
	virtual	bool	SeekTime(f64 time);

private:
	// hCuI[v
	bool	OpenDrive(int driveNumber);
};


}	// end of namespace ax
}	// end of namespace iris

#endif

#endif
