//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXWavFile.cpp
 * @brief		wavt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXWavFile_CPP_

//======================================================================
// inculde
#include "AXWavFile.h"
#include "../../../iris_debug.h"

namespace iris {
namespace ax
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CWavFile::CWavFile(void)
: m_Offset(-1)
, m_Size(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CWavFile::~CWavFile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	fname	= t@CpX
 * @return	
*//***********************************************************************/
bool CWavFile::OpenA(LPCSTR  fname)
{
	if( !m_File.OpenA(fname) ) return false;
	if( !_Open() )
	{
		m_File.Close();
		return false;
	}
	return true;
}
/// CWavFile::OpenA Q
bool CWavFile::OpenW(LPCWSTR fname)
{
	if( !m_File.OpenW(fname) ) return false;
	if( !_Open() )
	{
		m_File.Close();
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * JĂ邩ǂ
 *
*//***********************************************************************/
bool CWavFile::IsOpen(void) const
{
	if( m_Size == 0 ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CWavFile::Close(void)
{
	m_File.Close();
	m_Offset = -1;
	m_Size = 0;
}

/**********************************************************************//**
 *
 * PCMf[^̓ǂݎ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
 * @param [in]	size		= o̓obt@TCY
 * @return	WJobt@TCY
*//***********************************************************************/
u32 CWavFile::ReadPCM(void* lpBuffer, u32 size)
{
	s32 pos = m_File.Tell() - m_Offset;
	IRIS_ASSERT( pos >= 0 );
	if( pos + size > static_cast<u32>(m_Size) ) size = static_cast<u32>(m_Size - pos);
	u32 read = m_File.Read(lpBuffer, size);
	return read;
}

/**********************************************************************//**
 *
 * WAVEFORMATEX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pwfex	= WAVEFORMATEX
 * @return	
*//***********************************************************************/
bool CWavFile::GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const
{
	if( pwfex == nullptr ) return false;
	if( m_Size == 0 ) return false;
	pwfex->cbSize			= sizeof(WAVEFORMATEX);
	pwfex->wFormatTag		= m_Format.Fmt;
	pwfex->nChannels		= m_Format.Channels;
	pwfex->nSamplesPerSec	= m_Format.SamplePerSec;
	pwfex->wBitsPerSample	= m_Format.BitsWidth;
	pwfex->nAvgBytesPerSec	= m_Format.BytePerSec;
	pwfex->nBlockAlign		= m_Format.BlockAlign;
	return true;
}

/**********************************************************************//**
 *
 * tell
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(TvP)
*//***********************************************************************/
s32 CWavFile::Tell(void)	const
{
	s32 pos = m_File.Tell();
	if( pos < m_Offset ) return -1;
	if( static_cast<u32>(pos) >= m_Offset + m_Size ) return -1;
	return (pos - m_Offset) / (m_Format.BitsWidth * m_Format.Channels);
}

/**********************************************************************//**
 *
 * tell time
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(bP)
*//***********************************************************************/
f64 CWavFile::TellTime(void)	const
{
	s32 samples = Tell();
	if( samples == -1 ) return 0.0f;
	return (f64)samples / m_Format.SamplePerSec;
}

/**********************************************************************//**
 *
 * seek
 *
 ----------------------------------------------------------------------
 * @param [in]	samples	= TvP
 * @return	
*//***********************************************************************/
bool CWavFile::Seek(s32 samples)
{
	s32 pos = samples * m_Format.BitsWidth * m_Format.Channels;
	m_File.Seek(pos + m_Offset, fnd::FILE_SEEK_SET);
	return true;
}

/**********************************************************************//**
 *
 * seek time
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= bP
 * @return	
*//***********************************************************************/
bool CWavFile::SeekTime(f64 time)
{
	s32 samples = static_cast<s32>(time * m_Format.SamplePerSec);
	s32 pos = samples * m_Format.BitsWidth * m_Format.Channels;
	m_File.Seek(pos + m_Offset, fnd::FILE_SEEK_SET);
	return true;
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @param [io]	pFile		= ݐt@CiI[vς݁j
 * @param [in]	pAutdio		= ݃TEht@C
 * @param [in]	buf			= Ɨpobt@
 * @param [in]	work_size	= Ɨpobt@TCY
 * @return	
*//***********************************************************************/
bool CWavFile::WriteFile(fnd::IFile *pFile, IAXFile *pAudio, void* buf, u32 work_size)
{
	if( pFile == nullptr ) return false;
	if( pAudio == nullptr ) return false;
	if( buf == nullptr ) return false;
	if( work_size <= 0 ) return false;
	if( !pFile->IsOpen() ) return false;
	if( !pAudio->IsOpen() ) return false;
	pFile->Seek(0, fnd::FILE_SEEK_SET);

	WAVEFORMATEX wfex;
	if( !pAudio->GetWaveFormatEx(&wfex) ) return false;
	u32 size = pAudio->GetSize();

	fnd::RIFF_FMT_CHUNK fmt;
	fmt.uID		= fnd::RIFF_ID_FMT_CHUNK;
	fmt.Size	= sizeof(fmt) - sizeof(fnd::RIFF_CHUNK_HEADER);
	fmt.Channels		= wfex.nChannels;
	fmt.SamplePerSec	= wfex.nSamplesPerSec;
	fmt.BitsWidth		= wfex.wBitsPerSample;
	fmt.BytePerSec		= wfex.nAvgBytesPerSec;
	fmt.BitsWidth		= wfex.nBlockAlign;
	fmt.Fmt				= wfex.wFormatTag;

	fnd::RIFF_CHUNK_HEADER data;
	data.uID	= fnd::RIFF_ID_DATA_CHUNK;
	data.Size	= size;

	fnd::RIFF_FILE_CHUNK head;
	head.uForm = fnd::RIFF_FORM_WAVE;
	head.uID = fnd::RIFF_ID_FILE_CHUNK;
	head.Size = static_cast<s32>(sizeof(head) + sizeof(fmt) + sizeof(data) + size);

	pFile->Write(&head, sizeof(head));
	pFile->Write(&fmt, sizeof(fmt));
	pFile->Write(&data, sizeof(data));

	u32 rest = size;
	while(rest > 0)
	{
		u32 read_size = work_size;
		if( read_size > rest ) read_size = rest;
		read_size = pAudio->ReadPCM(buf, read_size);
		if( read_size == 0 ) return false;
		pFile->Write(buf, read_size);
		rest -= read_size;
	}
	return true;
}

/**********************************************************************//**
 * @internal
 *
 * I[vʏ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CWavFile::_Open(void)
{
	if( m_File.GetFormType() != fnd::RIFF_FORM_WAVE ) return false;

	// format
	if( !m_File.Descend(fnd::RIFF_ID_FMT_CHUNK) ) return false;
	if( m_File.Read(&m_Format, sizeof(fnd::RIFF_FMT_CHUNK)) == 0 ) return false;
	m_File.Ascend();

	// data
	if( !m_File.Descend(fnd::RIFF_ID_DATA_CHUNK) ) return false;
	fnd::RIFF_CHUNK_HEADER chunk;
	if( m_File.Read(&chunk, sizeof(fnd::RIFF_CHUNK_HEADER)) == 0 ) return false;
	m_Offset = m_File.Tell() + sizeof(fnd::RIFF_CHUNK_HEADER);
	m_Size = chunk.Size;
	m_File.Ascend();

	m_File.Seek(m_Offset, fnd::FILE_SEEK_SET);
	return true;

}

}	// end of namespace ax
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../../al/AXALSystem.h"
#include "../../al/AXALBuffer.h"
#include "../../al/AXALPlayer.h"
#include "../../../fnd/memory/FndMemBuffer.h"
#include <stdio.h>
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CAXWavFileUnitTest, Func)
{
	static const int STREAM_BUFFER_NUM	= 2;
	static const int STREAM_BUFFER_SIZE	= 8*1024;

	CWavFile wavfile;
#ifdef _IRIS_SUPPORT_OPENAL
	CALSystem system = CALSystem::CreateImplement();
	CALPlayer player;
	CALBuffer buffer[STREAM_BUFFER_NUM];
#endif

	TCHAR fname[MAX_PATH] = IRIS_TEXT("../../../data/snd/sample.wav");
#if !defined(_IRIS_SUPPORT_AUTO_UNITTEST)
	std::cout << "J wav t@C͂ĂB" << std::endl;
	std::tcin >> fname;
#endif
	if( !wavfile.Open(fname) )
	{
		return;
	}
	printf("file open %s.\n", fname);

	const fnd::RIFF_FMT_CHUNK&	fmt = wavfile.GetFormatChunk();
	printf("wav info.\n");
	printf("channels      %d\n", fmt.Channels);
	printf("SamplePerSec  %d\n", fmt.SamplePerSec);
	printf("BitsWidth     %d\n", fmt.BitsWidth);
	printf("BytePerSec    %d\n", fmt.BytePerSec);
	printf("Size          %d\n", fmt.Size);
	printf("BlockAlign    %d\n", fmt.BlockAlign);

#ifdef _IRIS_SUPPORT_OPENAL
	{
		WAVEFORMATEX wfex;
		wavfile.GetWaveFormatEx(&wfex);
		system.Initialize();
		player.Initialize();

		printf("play streaming.\n");

		fnd::CMemBuffer data[STREAM_BUFFER_NUM];
		for( int i=0; i < STREAM_BUFFER_NUM; ++i )
		{
			data[i].Alloc(STREAM_BUFFER_SIZE);
			u32 size = wavfile.ReadPCM(data[i], data[i].GetSize());
			buffer[i].Initialize();
			buffer[i].BindData(data[i], size, wfex.nChannels, wfex.nSamplesPerSec);

			player.StreamOut(&buffer[i], TRUE);
		}
		player.SetLoop(FALSE);
		player.Play();

		while( player.IsPlay() )
		{
			if( player.GetProcessedBufferNum() > 0 || player.GetQueueBufferNum() < STREAM_BUFFER_NUM )
			{
				player.Dequeue(1);
				for( int i=0; i < STREAM_BUFFER_NUM; ++i )
				{
					if( !buffer[i].IsRegistPlayer() )
					{
						u32 size = wavfile.ReadPCM(data[i], data[i].GetSize());
						if( size == 0 ) break;
						buffer[i].BindData(data[i], size, wfex.nChannels, wfex.nSamplesPerSec);
						player.StreamOut(&buffer[i], TRUE);
						player.Play();
						break;
					}
				}
			}
		}
	}
#endif
}

#endif
